/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Copyright (c) 2021 The Linux Foundation. All rights reserved.
 */

#ifndef _DT_BINDINGS_QCOM_SPMI_VADC_PM5100_H
#define _DT_BINDINGS_QCOM_SPMI_VADC_PM5100_H

#ifndef PM5100_SID
#define PM5100_SID					0
#endif

/* ADC channels for PM5100_ADC for PMIC5 Gen3 */
#define PM5100_ADC5_GEN3_OFFSET_REF			(PM5100_SID << 8 | 0x0)
#define PM5100_ADC5_GEN3_1P25VREF			(PM5100_SID << 8 | 0x01)
#define PM5100_ADC5_GEN3_VREF_VADC			(PM5100_SID << 8 | 0x02)
#define PM5100_ADC5_GEN3_DIE_TEMP			(PM5100_SID << 8 | 0x03)

#define PM5100_ADC5_GEN3_AMUX1_THM			(PM5100_SID << 8 | 0x04)
#define PM5100_ADC5_GEN3_BAT_ID				(PM5100_SID << 8 | 0x05)
#define PM5100_ADC5_GEN3_BATT_THM			(PM5100_SID << 8 | 0x06)
#define PM5100_ADC5_GEN3_AMUX4_THM			(PM5100_SID << 8 | 0x07)
#define PM5100_ADC5_GEN3_AMUX5_THM			(PM5100_SID << 8 | 0x08)
#define PM5100_ADC5_GEN3_AMUX6_THM			(PM5100_SID << 8 | 0x09)
#define PM5100_ADC5_GEN3_AMUX1_GPIO10			(PM5100_SID << 8 | 0x0a)
#define PM5100_ADC5_GEN3_AMUX2_GPIO11			(PM5100_SID << 8 | 0x0b)
#define PM5100_ADC5_GEN3_AMUX3_GPIO			(PM5100_SID << 8 | 0x0c)
#define PM5100_ADC5_GEN3_AMUX4_GPIO			(PM5100_SID << 8 | 0x0d)

#define PM5100_ADC5_GEN3_CHG_TEMP			(PM5100_SID << 8 | 0x10)
#define PM5100_ADC5_GEN3_USB_SNS_V_16			(PM5100_SID << 8 | 0x11)
#define PM5100_ADC5_GEN3_VIN_DIV16_MUX			(PM5100_SID << 8 | 0x12)
#define PM5100_ADC5_GEN3_USB_IN_I			(PM5100_SID << 8 | 0x17)
#define PM5100_ADC5_GEN3_ICHG_FB			(PM5100_SID << 8 | 0xa1)

/* 30k pull-up1 */
#define PM5100_ADC5_GEN3_AMUX1_THM_30K_PU		(PM5100_SID << 8 | 0x24)
#define PM5100_ADC5_GEN3_BAT_ID_30K_PU			(PM5100_SID << 8 | 0x25)
#define PM5100_ADC5_GEN3_BATT_THM_30K_PU		(PM5100_SID << 8 | 0x26)
#define PM5100_ADC5_GEN3_AMUX4_THM_30K_PU		(PM5100_SID << 8 | 0x27)
#define PM5100_ADC5_GEN3_AMUX5_THM_30K_PU		(PM5100_SID << 8 | 0x28)
#define PM5100_ADC5_GEN3_AMUX6_THM_30K_PU		(PM5100_SID << 8 | 0x29)
#define PM5100_ADC5_GEN3_AMUX1_GPIO10_30K_PU		(PM5100_SID << 8 | 0x2a)
#define PM5100_ADC5_GEN3_AMUX2_GPIO11_30K_PU		(PM5100_SID << 8 | 0x2b)
#define PM5100_ADC5_GEN3_AMUX3_GPIO_30K_PU		(PM5100_SID << 8 | 0x2c)
#define PM5100_ADC5_GEN3_AMUX4_GPIO_30K_PU		(PM5100_SID << 8 | 0x2d)

/* 100k pull-up2 */
#define PM5100_ADC5_GEN3_AMUX1_THM_100K_PU		(PM5100_SID << 8 | 0x44)
#define PM5100_ADC5_GEN3_BAT_ID_100K_PU			(PM5100_SID << 8 | 0x45)
#define PM5100_ADC5_GEN3_BATT_THM_100K_PU		(PM5100_SID << 8 | 0x46)
#define PM5100_ADC5_GEN3_AMUX4_THM_100K_PU		(PM5100_SID << 8 | 0x47)
#define PM5100_ADC5_GEN3_AMUX5_THM_100K_PU		(PM5100_SID << 8 | 0x48)
#define PM5100_ADC5_GEN3_AMUX6_THM_100K_PU		(PM5100_SID << 8 | 0x49)
#define PM5100_ADC5_GEN3_AMUX1_GPIO10_100K_PU		(PM5100_SID << 8 | 0x4a)
#define PM5100_ADC5_GEN3_AMUX2_GPIO11_100K_PU		(PM5100_SID << 8 | 0x4b)
#define PM5100_ADC5_GEN3_AMUX3_GPIO_100K_PU		(PM5100_SID << 8 | 0x4c)
#define PM5100_ADC5_GEN3_AMUX4_GPIO_100K_PU		(PM5100_SID << 8 | 0x4d)

/* 400k pull-up3 */
#define PM5100_ADC5_GEN3_AMUX1_THM_400K_PU		(PM5100_SID << 8 | 0x64)
#define PM5100_ADC5_GEN3_BAT_ID_400K_PU			(PM5100_SID << 8 | 0x65)
#define PM5100_ADC5_GEN3_BATT_THM_400K_PU		(PM5100_SID << 8 | 0x66)
#define PM5100_ADC5_GEN3_AMUX4_THM_400K_PU		(PM5100_SID << 8 | 0x67)
#define PM5100_ADC5_GEN3_AMUX5_THM_400K_PU		(PM5100_SID << 8 | 0x68)
#define PM5100_ADC5_GEN3_AMUX6_THM_400K_PU		(PM5100_SID << 8 | 0x69)
#define PM5100_ADC5_GEN3_AMUX1_GPIO10_400K_PU		(PM5100_SID << 8 | 0x6a)
#define PM5100_ADC5_GEN3_AMUX2_GPIO11_400K_PU		(PM5100_SID << 8 | 0x6b)
#define PM5100_ADC5_GEN3_AMUX3_GPIO_400K_PU		(PM5100_SID << 8 | 0x6c)
#define PM5100_ADC5_GEN3_AMUX4_GPIO_400K_PU		(PM5100_SID << 8 | 0x6d)

/* 1/3 Divider */
#define PM5100_ADC5_GEN3_GPIO10_DIV3			(PM5100_SID << 8 | 0x8a)
#define PM5100_ADC5_GEN3_GPIO11_DIV3			(PM5100_SID << 8 | 0x8b)

#define PM5100_ADC5_GEN3_VPH_PWR			(PM5100_SID << 8 | 0x8e)
#define PM5100_ADC5_GEN3_VBAT_SNS_QBG			(PM5100_SID << 8 | 0x8f)

#endif /* _DT_BINDINGS_QCOM_SPMI_VADC_PM5100_H */
