/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Copyright (c) 2020 The Linux Foundation. All rights reserved.
 */

#ifndef _DT_BINDINGS_QCOM_SPMI_VADC_PMX65_H
#define _DT_BINDINGS_QCOM_SPMI_VADC_PMX65_H

#ifndef PMX65_SID
#define PMX65_SID 1
#endif

#define PMX65_ADC7_REF_GND			(PMX65_SID << 8 | 0x00)
#define PMX65_ADC7_1P25VREF			(PMX65_SID << 8 | 0x01)
#define PMX65_ADC7_VREF_VADC			(PMX65_SID << 8 | 0x02)
#define PMX65_ADC7_DIE_TEMP			(PMX65_SID << 8 | 0x03)

#define PMX65_ADC7_AMUX_THM1			(PMX65_SID << 8 | 0x04)
#define PMX65_ADC7_AMUX_THM2			(PMX65_SID << 8 | 0x05)
#define PMX65_ADC7_AMUX_THM3			(PMX65_SID << 8 | 0x06)
#define PMX65_ADC7_AMUX_THM4			(PMX65_SID << 8 | 0x07)
#define PMX65_ADC7_AMUX_THM5			(PMX65_SID << 8 | 0x08)
#define PMX65_ADC7_AMUX_THM6			(PMX65_SID << 8 | 0x09)

#define PMX65_ADC7_GPIO05			(PMX65_SID << 8 | 0x0A)
#define PMX65_ADC7_GPIO12			(PMX65_SID << 8 | 0x0B)
#define PMX65_ADC7_GPIO15			(PMX65_SID << 8 | 0x0C)
#define PMX65_ADC7_GPIO16			(PMX65_SID << 8 | 0x0D)

/* 30k pull-ups */
#define PMX65_ADC7_AMUX_THM1_30K_PU		(PMX65_SID << 8 | 0x24)
#define PMX65_ADC7_AMUX_THM2_30K_PU		(PMX65_SID << 8 | 0x25)
#define PMX65_ADC7_AMUX_THM3_30K_PU		(PMX65_SID << 8 | 0x26)
#define PMX65_ADC7_AMUX_THM4_30K_PU		(PMX65_SID << 8 | 0x27)
#define PMX65_ADC7_AMUX_THM5_30K_PU		(PMX65_SID << 8 | 0x28)
#define PMX65_ADC7_AMUX_THM6_30K_PU		(PMX65_SID << 8 | 0x29)
#define PMX65_ADC7_GPIO05_30K_PU		(PMX65_SID << 8 | 0x2A)
#define PMX65_ADC7_GPIO12_30K_PU		(PMX65_SID << 8 | 0x2B)
#define PMX65_ADC7_GPIO15_30K_PU		(PMX65_SID << 8 | 0x2C)
#define PMX65_ADC7_GPIO16_30K_PU		(PMX65_SID << 8 | 0x2D)

/* 100k pull-ups */
#define PMX65_ADC7_AMUX_THM1_100K_PU		(PMX65_SID << 8 | 0x44)
#define PMX65_ADC7_AMUX_THM2_100K_PU		(PMX65_SID << 8 | 0x45)
#define PMX65_ADC7_AMUX_THM3_100K_PU		(PMX65_SID << 8 | 0x46)
#define PMX65_ADC7_AMUX_THM4_100K_PU		(PMX65_SID << 8 | 0x47)
#define PMX65_ADC7_AMUX_THM5_100K_PU		(PMX65_SID << 8 | 0x48)
#define PMX65_ADC7_AMUX_THM6_100K_PU		(PMX65_SID << 8 | 0x49)
#define PMX65_ADC7_GPIO05_100K_PU		(PMX65_SID << 8 | 0x4A)
#define PMX65_ADC7_GPIO12_100K_PU		(PMX65_SID << 8 | 0x4B)
#define PMX65_ADC7_GPIO15_100K_PU		(PMX65_SID << 8 | 0x4C)
#define PMX65_ADC7_GPIO16_100K_PU		(PMX65_SID << 8 | 0x4D)

/* 400k pull-ups */
#define PMX65_ADC7_AMUX_THM1_400K_PU		(PMX65_SID << 8 | 0x64)
#define PMX65_ADC7_AMUX_THM2_400K_PU		(PMX65_SID << 8 | 0x65)
#define PMX65_ADC7_AMUX_THM3_400K_PU		(PMX65_SID << 8 | 0x66)
#define PMX65_ADC7_AMUX_THM4_400K_PU		(PMX65_SID << 8 | 0x67)
#define PMX65_ADC7_AMUX_THM5_400K_PU		(PMX65_SID << 8 | 0x68)
#define PMX65_ADC7_AMUX_THM6_400K_PU		(PMX65_SID << 8 | 0x69)
#define PMX65_ADC7_GPIO05_400K_PU		(PMX65_SID << 8 | 0x6A)
#define PMX65_ADC7_GPIO12_400K_PU		(PMX65_SID << 8 | 0x6B)
#define PMX65_ADC7_GPIO15_400K_PU		(PMX65_SID << 8 | 0x6C)
#define PMX65_ADC7_GPIO16_400K_PU		(PMX65_SID << 8 | 0x6D)

/* Open, 1/3 Divider */
#define PMX65_ADC7_GPIO12_DIV3			(PMX65_SID << 8 | 0x8B)
#define PMX65_ADC7_GPIO15_DIV3			(PMX65_SID << 8 | 0x8C)
#define PMX65_ADC7_GPIO16_DIV3			(PMX65_SID << 8 | 0x8D)

#define PMX65_ADC7_VPH_PWR			(PMX65_SID << 8 | 0x8E)

#endif /* _DT_BINDINGS_QCOM_SPMI_VADC_PMX65_H */
