/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Copyright (c) 2021, The Linux Foundation. All rights reserved.
 */

#ifndef _DT_BINDINGS_PHY_QCOM_5NM_QMP_COMBO_USB4_H
#define _DT_BINDINGS_PHY_QCOM_5NM_QMP_COMBO_USB4_H

/* USB4-USB3-DP Combo PHY register offsets */
/* Module: USB43DP_COM_USB43DP_COM_USB4_USB3_DP_COM */
#define USB43DP_COM_PHY_MODE_CTRL				0x0000
#define USB43DP_COM_SW_RESET					0x0004
#define USB43DP_COM_POWER_DOWN_CTRL				0x0008
#define USB43DP_COM_SWI_CTRL					0x000C
#define USB43DP_COM_TYPEC_CTRL					0x0010
#define USB43DP_COM_TYPEC_PWRDN_CTRL				0x0014
#define USB43DP_COM_DP_BIST_CFG_0				0x0018
#define USB43DP_COM_RESET_OVRD_CTRL1				0x001C
#define USB43DP_COM_RESET_OVRD_CTRL2				0x0020
#define USB43DP_COM_DBG_CLK_MUX_CTRL				0x0024
#define USB43DP_COM_TYPEC_STATUS				0x0028
#define USB43DP_COM_PLACEHOLDER_STATUS				0x002C
#define USB43DP_COM_REVISION_ID0				0x0030
#define USB43DP_COM_REVISION_ID1				0x0034
#define USB43DP_COM_REVISION_ID2				0x0038
#define USB43DP_COM_REVISION_ID3				0x003C

/* Module: USB43DP_DBGINT_USB43DP_DBGINT_USB3_PCS_DEBUG_INT */
#define USB43DP_DBGINT_INTGEN_STATUS1				0x0200
#define USB43DP_DBGINT_INTGEN_STATUS2				0x0204
#define USB43DP_DBGINT_CONFIG1					0x0208
#define USB43DP_DBGINT_SIGNALBLK1_CONFIG1			0x020C
#define USB43DP_DBGINT_SIGNALBLK1_CONFIG2			0x0210
#define USB43DP_DBGINT_SIGNALBLK1_CONFIG3			0x0214
#define USB43DP_DBGINT_SIGNALBLK1_CONFIG4			0x0218
#define USB43DP_DBGINT_SIGNALBLK1_CONFIG5			0x021C
#define USB43DP_DBGINT_SIGNALBLK2_CONFIG1			0x0220
#define USB43DP_DBGINT_SIGNALBLK2_CONFIG2			0x0224
#define USB43DP_DBGINT_SIGNALBLK2_CONFIG3			0x0228
#define USB43DP_DBGINT_SIGNALBLK2_CONFIG4			0x022C
#define USB43DP_DBGINT_SIGNALBLK2_CONFIG5			0x0230
#define USB43DP_DBGINT_STRINGBLK1_CONFIG1			0x0234
#define USB43DP_DBGINT_STRINGBLK1_CONFIG2			0x0238
#define USB43DP_DBGINT_STRINGBLK1_CONFIG3			0x023C
#define USB43DP_DBGINT_STRINGBLK1_CONFIG4			0x0240
#define USB43DP_DBGINT_STRINGBLK1_CONFIG5			0x0244
#define USB43DP_DBGINT_STRINGBLK2_CONFIG1			0x0248
#define USB43DP_DBGINT_STRINGBLK2_CONFIG2			0x024C
#define USB43DP_DBGINT_STRINGBLK2_CONFIG3			0x0250
#define USB43DP_DBGINT_STRINGBLK2_CONFIG4			0x0254
#define USB43DP_DBGINT_STRINGBLK2_CONFIG5			0x0258

/* Module: USB43DP_QSERDES_TXA_USB43DP_QSERDES_TXA_USB4_USB3_DP_QMP_TX */
#define USB43DP_QSERDES_TXA_BIST_MODE_LANENO			0x0400
#define USB43DP_QSERDES_TXA_BIST_INVERT				0x0404
#define USB43DP_QSERDES_TXA_CLKBUF_ENABLE			0x0408
#define USB43DP_QSERDES_TXA_TX_EMP_POST1_LVL			0x040C
#define USB43DP_QSERDES_TXA_TX_IDLE_LVL_LARGE_AMP		0x0410
#define USB43DP_QSERDES_TXA_TX_DRV_LVL				0x0414
#define USB43DP_QSERDES_TXA_TX_DRV_LVL_OFFSET			0x0418
#define USB43DP_QSERDES_TXA_RESET_TSYNC_EN			0x041C
#define USB43DP_QSERDES_TXA_PRE_STALL_LDO_BOOST_EN		0x0420
#define USB43DP_QSERDES_TXA_LPB_EN				0x0424
#define USB43DP_QSERDES_TXA_RES_CODE_LANE_TX			0x0428
#define USB43DP_QSERDES_TXA_RES_CODE_LANE_RX			0x042C
#define USB43DP_QSERDES_TXA_RES_CODE_LANE_OFFSET_TX		0x0430
#define USB43DP_QSERDES_TXA_RES_CODE_LANE_OFFSET_RX		0x0434
#define USB43DP_QSERDES_TXA_PERL_LENGTH1			0x0438
#define USB43DP_QSERDES_TXA_PERL_LENGTH2			0x043C
#define USB43DP_QSERDES_TXA_SERDES_BYP_EN_OUT			0x0440
#define USB43DP_QSERDES_TXA_DEBUG_BUS_SEL			0x0444
#define USB43DP_QSERDES_TXA_TRANSCEIVER_BIAS_EN			0x0448
#define USB43DP_QSERDES_TXA_HIGHZ_DRVR_EN			0x044C
#define USB43DP_QSERDES_TXA_TX_POL_INV				0x0450
#define USB43DP_QSERDES_TXA_PARRATE_REC_DETECT_IDLE_EN		0x0454
#define USB43DP_QSERDES_TXA_BIST_PATTERN1			0x0458
#define USB43DP_QSERDES_TXA_BIST_PATTERN2			0x045C
#define USB43DP_QSERDES_TXA_BIST_PATTERN3			0x0460
#define USB43DP_QSERDES_TXA_BIST_PATTERN4			0x0464
#define USB43DP_QSERDES_TXA_BIST_PATTERN5			0x0468
#define USB43DP_QSERDES_TXA_BIST_PATTERN6			0x046C
#define USB43DP_QSERDES_TXA_BIST_PATTERN7			0x0470
#define USB43DP_QSERDES_TXA_BIST_PATTERN8			0x0474
#define USB43DP_QSERDES_TXA_LANE_MODE_1				0x0478
#define USB43DP_QSERDES_TXA_LANE_MODE_2				0x047C
#define USB43DP_QSERDES_TXA_LANE_MODE_3				0x0480
#define USB43DP_QSERDES_TXA_ATB_SEL1				0x0484
#define USB43DP_QSERDES_TXA_ATB_SEL2				0x0488
#define USB43DP_QSERDES_TXA_RCV_DETECT_LVL			0x048C
#define USB43DP_QSERDES_TXA_RCV_DETECT_LVL_2			0x0490
#define USB43DP_QSERDES_TXA_PRBS_SEED1				0x0494
#define USB43DP_QSERDES_TXA_PRBS_SEED2				0x0498
#define USB43DP_QSERDES_TXA_PRBS_SEED3				0x049C
#define USB43DP_QSERDES_TXA_PRBS_SEED4				0x04A0
#define USB43DP_QSERDES_TXA_RESET_GEN				0x04A4
#define USB43DP_QSERDES_TXA_RESET_GEN_MUXES			0x04A8
#define USB43DP_QSERDES_TXA_TRAN_DRVR_EMP_EN			0x04AC
#define USB43DP_QSERDES_TXA_VMODE_CTRL1				0x04B0
#define USB43DP_QSERDES_TXA_ALOG_OBSV_BUS_CTRL_1		0x04B4
#define USB43DP_QSERDES_TXA_BIST_STATUS				0x04B8
#define USB43DP_QSERDES_TXA_BIST_ERROR_COUNT1			0x04BC
#define USB43DP_QSERDES_TXA_BIST_ERROR_COUNT2			0x04C0
#define USB43DP_QSERDES_TXA_ALOG_OBSV_BUS_STATUS_1		0x04C4
#define USB43DP_QSERDES_TXA_LANE_DIG_CONFIG			0x04C8
#define USB43DP_QSERDES_TXA_PI_QEC_CTRL				0x04CC
#define USB43DP_QSERDES_TXA_PRE_EMPH				0x04D0
#define USB43DP_QSERDES_TXA_SW_RESET				0x04D4
#define USB43DP_QSERDES_TXA_TX_BAND				0x04D8
#define USB43DP_QSERDES_TXA_SLEW_CNTL0				0x04DC
#define USB43DP_QSERDES_TXA_SLEW_CNTL1				0x04E0
#define USB43DP_QSERDES_TXA_INTERFACE_SELECT			0x04E4
#define USB43DP_QSERDES_TXA_DIG_BKUP_CTRL			0x04E8
#define USB43DP_QSERDES_TXA_DEBUG_BUS0				0x04EC
#define USB43DP_QSERDES_TXA_DEBUG_BUS1				0x04F0
#define USB43DP_QSERDES_TXA_DEBUG_BUS2				0x04F4
#define USB43DP_QSERDES_TXA_DEBUG_BUS3				0x04F8
#define USB43DP_QSERDES_TXA_TX_BKUP_RO_BUS			0x04FC

/* Module: USB43DP_QSERDES_RXA_USB43DP_QSERDES_RXA_USB4_USB3_DP_QMP_RX */
#define USB43DP_QSERDES_RXA_UCDR_FASTLOCK_FO_GAIN_RATE0		0x0600
#define USB43DP_QSERDES_RXA_UCDR_FASTLOCK_FO_GAIN_RATE1		0x0604
#define USB43DP_QSERDES_RXA_UCDR_FASTLOCK_FO_GAIN_RATE2		0x0608
#define USB43DP_QSERDES_RXA_UCDR_FASTLOCK_FO_GAIN_RATE3		0x060C
#define USB43DP_QSERDES_RXA_UCDR_FASTLOCK_SO_GAIN_RATE0		0x0610
#define USB43DP_QSERDES_RXA_UCDR_FASTLOCK_SO_GAIN_RATE1		0x0614
#define USB43DP_QSERDES_RXA_UCDR_FASTLOCK_SO_GAIN_RATE2		0x0618
#define USB43DP_QSERDES_RXA_UCDR_FASTLOCK_SO_GAIN_RATE3		0x061C
#define USB43DP_QSERDES_RXA_UCDR_SO_SATURATION			0x0620
#define USB43DP_QSERDES_RXA_UCDR_FO_TO_SO_DELAY			0x0624
#define USB43DP_QSERDES_RXA_UCDR_FASTLOCK_COUNT_LOW_RATE0	0x0628
#define USB43DP_QSERDES_RXA_UCDR_FASTLOCK_COUNT_HIGH_RATE0	0x062C
#define USB43DP_QSERDES_RXA_UCDR_FASTLOCK_COUNT_LOW_RATE1	0x0630
#define USB43DP_QSERDES_RXA_UCDR_FASTLOCK_COUNT_HIGH_RATE1	0x0634
#define USB43DP_QSERDES_RXA_UCDR_FASTLOCK_COUNT_LOW_RATE2	0x0638
#define USB43DP_QSERDES_RXA_UCDR_FASTLOCK_COUNT_HIGH_RATE2	0x063C
#define USB43DP_QSERDES_RXA_UCDR_FASTLOCK_COUNT_LOW_RATE3	0x0640
#define USB43DP_QSERDES_RXA_UCDR_FASTLOCK_COUNT_HIGH_RATE3	0x0644
#define USB43DP_QSERDES_RXA_UCDR_PI_CTRL1			0x0648
#define USB43DP_QSERDES_RXA_UCDR_PI_CTRL2			0x064C
#define USB43DP_QSERDES_RXA_UCDR_SB2_THRESH1_RATE0		0x0650
#define USB43DP_QSERDES_RXA_UCDR_SB2_THRESH1_RATE1		0x0654
#define USB43DP_QSERDES_RXA_UCDR_SB2_THRESH1_RATE2		0x0658
#define USB43DP_QSERDES_RXA_UCDR_SB2_THRESH1_RATE3		0x065C
#define USB43DP_QSERDES_RXA_UCDR_SB2_THRESH2_RATE0		0x0660
#define USB43DP_QSERDES_RXA_UCDR_SB2_THRESH2_RATE1		0x0664
#define USB43DP_QSERDES_RXA_UCDR_SB2_THRESH2_RATE2		0x0668
#define USB43DP_QSERDES_RXA_UCDR_SB2_THRESH2_RATE3		0x066C
#define USB43DP_QSERDES_RXA_UCDR_SB2_GAIN1_RATE0		0x0670
#define USB43DP_QSERDES_RXA_UCDR_SB2_GAIN1_RATE1		0x0674
#define USB43DP_QSERDES_RXA_UCDR_SB2_GAIN1_RATE2		0x0678
#define USB43DP_QSERDES_RXA_UCDR_SB2_GAIN1_RATE3		0x067C
#define USB43DP_QSERDES_RXA_UCDR_SB2_GAIN2_RATE0		0x0680
#define USB43DP_QSERDES_RXA_UCDR_SB2_GAIN2_RATE1		0x0684
#define USB43DP_QSERDES_RXA_UCDR_SB2_GAIN2_RATE2		0x0688
#define USB43DP_QSERDES_RXA_UCDR_SB2_GAIN2_RATE3		0x068C
#define USB43DP_QSERDES_RXA_RXCLK_DIV2_CTRL			0x0690
#define USB43DP_QSERDES_RXA_RX_BAND				0x0694
#define USB43DP_QSERDES_RXA_RX_TERM_BW				0x0698
#define USB43DP_QSERDES_RXA_UCDR_FO_GAIN_RATE0			0x069C
#define USB43DP_QSERDES_RXA_UCDR_FO_GAIN_RATE1			0x06A0
#define USB43DP_QSERDES_RXA_UCDR_FO_GAIN_RATE2			0x06A4
#define USB43DP_QSERDES_RXA_UCDR_FO_GAIN_RATE3			0x06A8
#define USB43DP_QSERDES_RXA_UCDR_SO_GAIN_RATE0			0x06AC
#define USB43DP_QSERDES_RXA_UCDR_SO_GAIN_RATE1			0x06B0
#define USB43DP_QSERDES_RXA_UCDR_SO_GAIN_RATE2			0x06B4
#define USB43DP_QSERDES_RXA_UCDR_SO_GAIN_RATE3			0x06B8
#define USB43DP_QSERDES_RXA_UCDR_PI_CONTROLS			0x06BC
#define USB43DP_QSERDES_RXA_UCDR_PD_DATA_FILTER_ENABLES		0x06C0
#define USB43DP_QSERDES_RXA_UCDR_SO_ACC_DEFAULT_VAL_RATE0	0x06C4
#define USB43DP_QSERDES_RXA_UCDR_SO_ACC_DEFAULT_VAL_RATE1	0x06C8
#define USB43DP_QSERDES_RXA_UCDR_SO_ACC_DEFAULT_VAL_RATE2	0x06CC
#define USB43DP_QSERDES_RXA_UCDR_SO_ACC_DEFAULT_VAL_RATE3	0x06D0
#define USB43DP_QSERDES_RXA_AUX_CONTROL				0x06D4
#define USB43DP_QSERDES_RXA_AUXDATA_TB				0x06D8
#define USB43DP_QSERDES_RXA_RCLK_AUXDATA_SEL			0x06DC
#define USB43DP_QSERDES_RXA_EOM_CTRL				0x06E0
#define USB43DP_QSERDES_RXA_AC_JTAG_ENABLE			0x06E4
#define USB43DP_QSERDES_RXA_AC_JTAG_INITP			0x06E8
#define USB43DP_QSERDES_RXA_AC_JTAG_INITN			0x06EC
#define USB43DP_QSERDES_RXA_AC_JTAG_LVL				0x06F0
#define USB43DP_QSERDES_RXA_AC_JTAG_MODE			0x06F4
#define USB43DP_QSERDES_RXA_AC_JTAG_RESET			0x06F8
#define USB43DP_QSERDES_RXA_RX_RCVR_IQ_EN			0x06FC
#define USB43DP_QSERDES_RXA_RX_Q_EN_RATES			0x0700
#define USB43DP_QSERDES_RXA_RX_IDAC_I0_DC_OFFSETS		0x0704
#define USB43DP_QSERDES_RXA_RX_IDAC_I0BAR_DC_OFFSETS		0x0708
#define USB43DP_QSERDES_RXA_RX_IDAC_I1_DC_OFFSETS		0x070C
#define USB43DP_QSERDES_RXA_RX_IDAC_I1BAR_DC_OFFSETS		0x0710
#define USB43DP_QSERDES_RXA_RX_IDAC_Q_DC_OFFSETS		0x0714
#define USB43DP_QSERDES_RXA_RX_IDAC_QBAR_DC_OFFSETS		0x0718
#define USB43DP_QSERDES_RXA_RX_IDAC_A_DC_OFFSETS		0x071C
#define USB43DP_QSERDES_RXA_RX_IDAC_ABAR_DC_OFFSETS		0x0720
#define USB43DP_QSERDES_RXA_RX_IDAC_EN				0x0724
#define USB43DP_QSERDES_RXA_RX_IDAC_ENABLES			0x0728
#define USB43DP_QSERDES_RXA_RX_IDAC_SIGN			0x072C
#define USB43DP_QSERDES_RXA_RX_IVCM_CAL_CODE_OVERRIDE		0x0730
#define USB43DP_QSERDES_RXA_RX_IVCM_CAL_CTRL1			0x0734
#define USB43DP_QSERDES_RXA_RX_IVCM_CAL_CTRL2			0x0738
#define USB43DP_QSERDES_RXA_RX_IVCM_POSTCAL_OFFSET		0x073C
#define USB43DP_QSERDES_RXA_RX_SUMMER_CAL_SPD_MODE		0x0740
#define USB43DP_QSERDES_RXA_RX_HIGHZ_PARRATE			0x0744
#define USB43DP_QSERDES_RXA_RX_TERM_AC_BYPASS_DC_COUPLE_OFFSET	0x0748
#define USB43DP_QSERDES_RXA_DFE_1				0x074C
#define USB43DP_QSERDES_RXA_DFE_2				0x0750
#define USB43DP_QSERDES_RXA_DFE_3				0x0754
#define USB43DP_QSERDES_RXA_DFE_4				0x0758
#define USB43DP_QSERDES_RXA_DFE_TAP3_CTRL			0x075C
#define USB43DP_QSERDES_RXA_DFE_TAP3_MANVAL_KTAP		0x0760
#define USB43DP_QSERDES_RXA_DFE_TAP4_CTRL			0x0764
#define USB43DP_QSERDES_RXA_DFE_TAP4_MANVAL_KTAP		0x0768
#define USB43DP_QSERDES_RXA_DFE_TAP5_CTRL			0x076C
#define USB43DP_QSERDES_RXA_DFE_TAP5_MANVAL_KTAP		0x0770
#define USB43DP_QSERDES_RXA_TX_ADPT_CTRL			0x0774
#define USB43DP_QSERDES_RXA_DFE_DAC_ENABLE1			0x0778
#define USB43DP_QSERDES_RXA_DFE_DAC_ENABLE2			0x077C
#define USB43DP_QSERDES_RXA_TX_ADAPT_PRE_THRESH1		0x0780
#define USB43DP_QSERDES_RXA_TX_ADAPT_PRE_THRESH2		0x0784
#define USB43DP_QSERDES_RXA_TX_ADAPT_POST_THRESH1		0x0788
#define USB43DP_QSERDES_RXA_TX_ADAPT_POST_THRESH2		0x078C
#define USB43DP_QSERDES_RXA_TX_ADAPT_MAIN_THRESH1		0x0790
#define USB43DP_QSERDES_RXA_TX_ADAPT_MAIN_THRESH2		0x0794
#define USB43DP_QSERDES_RXA_VGA_CAL_CNTRL1			0x0798
#define USB43DP_QSERDES_RXA_VGA_CAL_CNTRL2			0x079C
#define USB43DP_QSERDES_RXA_VGA_CAL_MAN_VAL			0x07A0
#define USB43DP_QSERDES_RXA_VTHRESH_CAL_CNTRL1			0x07A4
#define USB43DP_QSERDES_RXA_VTHRESH_CAL_CNTRL2			0x07A8
#define USB43DP_QSERDES_RXA_VTHRESH_CAL_MAN_VAL_RATE0		0x07AC
#define USB43DP_QSERDES_RXA_VTHRESH_CAL_MAN_VAL_RATE1		0x07B0
#define USB43DP_QSERDES_RXA_VTHRESH_CAL_MAN_VAL_RATE2		0x07B4
#define USB43DP_QSERDES_RXA_VTHRESH_CAL_MAN_VAL_RATE3		0x07B8
#define USB43DP_QSERDES_RXA_GM_CAL				0x07BC
#define USB43DP_QSERDES_RXA_RX_VGA_GAIN2_BLK1			0x07C0
#define USB43DP_QSERDES_RXA_RX_VGA_GAIN2_BLK2			0x07C4
#define USB43DP_QSERDES_RXA_RX_EQU_ADAPTOR_CNTRL2		0x07C8
#define USB43DP_QSERDES_RXA_RX_EQU_ADAPTOR_CNTRL3		0x07CC
#define USB43DP_QSERDES_RXA_RX_EQU_ADAPTOR_CNTRL4		0x07D0
#define USB43DP_QSERDES_RXA_RX_IDAC_TSETTLE_LOW			0x07D4
#define USB43DP_QSERDES_RXA_RX_EQ_OFFSET_LSB			0x07D8
#define USB43DP_QSERDES_RXA_RX_EQ_OFFSET_MSB			0x07DC
#define USB43DP_QSERDES_RXA_RX_EQ_OFFSET_ADAPTOR_CNTRL1		0x07E0
#define USB43DP_QSERDES_RXA_RX_OFFSET_ADAPTOR_CNTRL2		0x07E4
#define USB43DP_QSERDES_RXA_SIGDET_ENABLES			0x07E8
#define USB43DP_QSERDES_RXA_SIGDET_CNTRL			0x07EC
#define USB43DP_QSERDES_RXA_SIGDET_LVL				0x07F0
#define USB43DP_QSERDES_RXA_SIGDET_DEGLITCH_CNTRL		0x07F4
#define USB43DP_QSERDES_RXA_CDR_FREEZE_UP_DN			0x07F8
#define USB43DP_QSERDES_RXA_CDR_RESET_OVERRIDE			0x07FC
#define USB43DP_QSERDES_RXA_RX_INTERFACE_MODE			0x0800
#define USB43DP_QSERDES_RXA_JITTER_GEN_MODE			0x0804
#define USB43DP_QSERDES_RXA_SJ_AMP1				0x0808
#define USB43DP_QSERDES_RXA_SJ_AMP2				0x080C
#define USB43DP_QSERDES_RXA_SJ_PER1				0x0810
#define USB43DP_QSERDES_RXA_SJ_PER2				0x0814
#define USB43DP_QSERDES_RXA_PPM_OFFSET1				0x0818
#define USB43DP_QSERDES_RXA_PPM_OFFSET2				0x081C
#define USB43DP_QSERDES_RXA_SIGN_PPM_PERIOD1			0x0820
#define USB43DP_QSERDES_RXA_SIGN_PPM_PERIOD2			0x0824
#define USB43DP_QSERDES_RXA_RX_MODE_RATE_0_1_B0			0x0828
#define USB43DP_QSERDES_RXA_RX_MODE_RATE_0_1_B1			0x082C
#define USB43DP_QSERDES_RXA_RX_MODE_RATE_0_1_B2			0x0830
#define USB43DP_QSERDES_RXA_RX_MODE_RATE_0_1_B3			0x0834
#define USB43DP_QSERDES_RXA_RX_MODE_RATE_0_1_B4			0x0838
#define USB43DP_QSERDES_RXA_RX_MODE_RATE_0_1_B5			0x083C
#define USB43DP_QSERDES_RXA_RX_MODE_RATE_0_1_B6			0x0840
#define USB43DP_QSERDES_RXA_RX_MODE_RATE_0_1_B7			0x0844
#define USB43DP_QSERDES_RXA_RX_MODE_RATE2_B0			0x0848
#define USB43DP_QSERDES_RXA_RX_MODE_RATE2_B1			0x084C
#define USB43DP_QSERDES_RXA_RX_MODE_RATE2_B2			0x0850
#define USB43DP_QSERDES_RXA_RX_MODE_RATE2_B3			0x0854
#define USB43DP_QSERDES_RXA_RX_MODE_RATE2_B4			0x0858
#define USB43DP_QSERDES_RXA_RX_MODE_RATE2_B5			0x085C
#define USB43DP_QSERDES_RXA_RX_MODE_RATE2_B6			0x0860
#define USB43DP_QSERDES_RXA_RX_MODE_RATE2_B7			0x0864
#define USB43DP_QSERDES_RXA_RX_MODE_RATE3_B0			0x0868
#define USB43DP_QSERDES_RXA_RX_MODE_RATE3_B1			0x086C
#define USB43DP_QSERDES_RXA_RX_MODE_RATE3_B2			0x0870
#define USB43DP_QSERDES_RXA_RX_MODE_RATE3_B3			0x0874
#define USB43DP_QSERDES_RXA_RX_MODE_RATE3_B4			0x0878
#define USB43DP_QSERDES_RXA_RX_MODE_RATE3_B5			0x087C
#define USB43DP_QSERDES_RXA_RX_MODE_RATE3_B6			0x0880
#define USB43DP_QSERDES_RXA_RX_MODE_RATE3_B7			0x0884
#define USB43DP_QSERDES_RXA_PHPRE_CTRL				0x0888
#define USB43DP_QSERDES_RXA_PHPRE_INITVAL			0x088C
#define USB43DP_QSERDES_RXA_DFE_EN_TIMER			0x0890
#define USB43DP_QSERDES_RXA_DFE_CTLE_POST_CAL_OFFSET		0x0894
#define USB43DP_QSERDES_RXA_DCC_CTRL1				0x0898
#define USB43DP_QSERDES_RXA_DCC_CTRL2				0x089C
#define USB43DP_QSERDES_RXA_DCC_OFFSET				0x08A0
#define USB43DP_QSERDES_RXA_DCC_CMUX_POSTCAL_OFFSET		0x08A4
#define USB43DP_QSERDES_RXA_DCC_CMUX_CAL_CTRL1			0x08A8
#define USB43DP_QSERDES_RXA_DCC_CMUX_CAL_CTRL2			0x08AC
#define USB43DP_QSERDES_RXA_ALOG_OBSV_BUS_CTRL_1		0x08B0
#define USB43DP_QSERDES_RXA_RX_MARG_CTRL1			0x08B4
#define USB43DP_QSERDES_RXA_RX_MARG_CTRL2			0x08B8
#define USB43DP_QSERDES_RXA_RX_MARG_CTRL3			0x08BC
#define USB43DP_QSERDES_RXA_RX_MARG_CTRL_4			0x08C0
#define USB43DP_QSERDES_RXA_RX_MARG_CFG_RATE_0_1		0x08C4
#define USB43DP_QSERDES_RXA_RX_MARG_CFG_RATE_2_3		0x08C8
#define USB43DP_QSERDES_RXA_RX_MARG_COARSE_CTRL1		0x08CC
#define USB43DP_QSERDES_RXA_RX_MARG_COARSE_CTRL2		0x08D0
#define USB43DP_QSERDES_RXA_RX_MARG_COARSE_THRESH1_RATE210	0x08D4
#define USB43DP_QSERDES_RXA_RX_MARG_COARSE_THRESH1_RATE3	0x08D8
#define USB43DP_QSERDES_RXA_RX_MARG_COARSE_THRESH2_RATE210	0x08DC
#define USB43DP_QSERDES_RXA_RX_MARG_COARSE_THRESH2_RATE3	0x08E0
#define USB43DP_QSERDES_RXA_RX_MARG_COARSE_THRESH3_RATE210	0x08E4
#define USB43DP_QSERDES_RXA_RX_MARG_COARSE_THRESH3_RATE3	0x08E8
#define USB43DP_QSERDES_RXA_RX_MARG_COARSE_THRESH4_RATE210	0x08EC
#define USB43DP_QSERDES_RXA_RX_MARG_COARSE_THRESH4_RATE3	0x08F0
#define USB43DP_QSERDES_RXA_RX_MARG_COARSE_THRESH5_RATE210	0x08F4
#define USB43DP_QSERDES_RXA_RX_MARG_COARSE_THRESH5_RATE3	0x08F8
#define USB43DP_QSERDES_RXA_RX_MARG_COARSE_THRESH6_RATE210	0x08FC
#define USB43DP_QSERDES_RXA_RX_MARG_COARSE_THRESH6_RATE3	0x0900
#define USB43DP_QSERDES_RXA_RX_MARG_COARSE_THRESH7_RATE210	0x0904
#define USB43DP_QSERDES_RXA_RX_MARG_COARSE_THRESH7_RATE3	0x0908
#define USB43DP_QSERDES_RXA_Q_PI_INTRINSIC_BIAS_RATE10		0x090C
#define USB43DP_QSERDES_RXA_Q_PI_INTRINSIC_BIAS_RATE32		0x0910
#define USB43DP_QSERDES_RXA_RX_MARG_VERTICAL_CTRL		0x0914
#define USB43DP_QSERDES_RXA_RX_MARG_VERTICAL_CODE		0x0918
#define USB43DP_QSERDES_RXA_RES_CODE_THRESH_HIGH_AND_BYP	0x091C
#define USB43DP_QSERDES_RXA_RES_CODE_THRESH_LOW			0x0920
#define USB43DP_QSERDES_RXA_RX_BKUP_CTRL1			0x0924
#define USB43DP_QSERDES_RXA_RX_BKUP_CTRL2			0x0928
#define USB43DP_QSERDES_RXA_RX_BKUP_CTRL3			0x092C
#define USB43DP_QSERDES_RXA_PI_CTRL1				0x0930
#define USB43DP_QSERDES_RXA_PI_CTRL2				0x0934
#define USB43DP_QSERDES_RXA_PI_QUAD				0x0938
#define USB43DP_QSERDES_RXA_QPI_CTRL1				0x093C
#define USB43DP_QSERDES_RXA_QPI_CTRL2				0x0940
#define USB43DP_QSERDES_RXA_QPI_QUAD				0x0944
#define USB43DP_QSERDES_RXA_IDATA1				0x0948
#define USB43DP_QSERDES_RXA_IDATA2				0x094C
#define USB43DP_QSERDES_RXA_IDATA3				0x0950
#define USB43DP_QSERDES_RXA_AC_JTAG_OUTP			0x0954
#define USB43DP_QSERDES_RXA_AC_JTAG_OUTN			0x0958
#define USB43DP_QSERDES_RXA_RX_SIGDET				0x095C
#define USB43DP_QSERDES_RXA_ALOG_OBSV_BUS_STATUS_1		0x0960
#define USB43DP_QSERDES_RXA_READ_EQCODE				0x0964
#define USB43DP_QSERDES_RXA_READ_OFFSETCODE			0x0968
#define USB43DP_QSERDES_RXA_IA_ERROR_COUNTER_LOW		0x096C
#define USB43DP_QSERDES_RXA_IA_ERROR_COUNTER_HIGH		0x0970
#define USB43DP_QSERDES_RXA_VGA_READ_CODE			0x0974
#define USB43DP_QSERDES_RXA_VTHRESH_READ_CODE			0x0978
#define USB43DP_QSERDES_RXA_DFE_TAP1_READ_CODE			0x097C
#define USB43DP_QSERDES_RXA_DFE_TAP2_READ_CODE			0x0980
#define USB43DP_QSERDES_RXA_DFE_TAP3_READ_CODE			0x0984
#define USB43DP_QSERDES_RXA_DFE_TAP4_READ_CODE			0x0988
#define USB43DP_QSERDES_RXA_DFE_TAP5_READ_CODE			0x098C
#define USB43DP_QSERDES_RXA_IDAC_STATUS_I0			0x0990
#define USB43DP_QSERDES_RXA_IDAC_STATUS_I0BAR			0x0994
#define USB43DP_QSERDES_RXA_IDAC_STATUS_I1			0x0998
#define USB43DP_QSERDES_RXA_IDAC_STATUS_I1BAR			0x099C
#define USB43DP_QSERDES_RXA_IDAC_STATUS_Q			0x09A0
#define USB43DP_QSERDES_RXA_IDAC_STATUS_QBAR			0x09A4
#define USB43DP_QSERDES_RXA_IDAC_STATUS_A			0x09A8
#define USB43DP_QSERDES_RXA_IDAC_STATUS_ABAR			0x09AC
#define USB43DP_QSERDES_RXA_IDAC_STATUS_SM_ON			0x09B0
#define USB43DP_QSERDES_RXA_IDAC_STATUS_SIGNERROR		0x09B4
#define USB43DP_QSERDES_RXA_IVCM_CAL_STATUS			0x09B8
#define USB43DP_QSERDES_RXA_IVCM_CAL_DEBUG_STATUS		0x09BC
#define USB43DP_QSERDES_RXA_DCC_CAL_STATUS			0x09C0
#define USB43DP_QSERDES_RXA_DCC_READ_CODE_STATUS		0x09C4
#define USB43DP_QSERDES_RXA_RX_MARG_DEBUG1_STATUS		0x09C8
#define USB43DP_QSERDES_RXA_RX_MARG_DEBUG2_STATUS		0x09CC
#define USB43DP_QSERDES_RXA_RX_MARG_READ_CODE_STATUS		0x09D0
#define USB43DP_QSERDES_RXA_EOM_ERR_CNT_LSB_STATUS		0x09D4
#define USB43DP_QSERDES_RXA_EOM_ERR_CNT_MSB_STATUS		0x09D8
#define USB43DP_QSERDES_RXA_RX_MARG_COARSE_TUNE_STATUS		0x09DC
#define USB43DP_QSERDES_RXA_RX_BKUP_READ_BUS1_STATUS		0x09E0
#define USB43DP_QSERDES_RXA_RX_BKUP_READ_BUS2_STATUS		0x09E4
#define USB43DP_QSERDES_RXA_RX_BKUP_READ_BUS3_STATUS		0x09E8

/* Module: USB43DP_QSERDES_TXB_USB43DP_QSERDES_TXB_USB4_USB3_DP_QMP_TX */
#define USB43DP_QSERDES_TXB_BIST_MODE_LANENO			0x0A00
#define USB43DP_QSERDES_TXB_BIST_INVERT				0x0A04
#define USB43DP_QSERDES_TXB_CLKBUF_ENABLE			0x0A08
#define USB43DP_QSERDES_TXB_TX_EMP_POST1_LVL			0x0A0C
#define USB43DP_QSERDES_TXB_TX_IDLE_LVL_LARGE_AMP		0x0A10
#define USB43DP_QSERDES_TXB_TX_DRV_LVL				0x0A14
#define USB43DP_QSERDES_TXB_TX_DRV_LVL_OFFSET			0x0A18
#define USB43DP_QSERDES_TXB_RESET_TSYNC_EN			0x0A1C
#define USB43DP_QSERDES_TXB_PRE_STALL_LDO_BOOST_EN		0x0A20
#define USB43DP_QSERDES_TXB_LPB_EN				0x0A24
#define USB43DP_QSERDES_TXB_RES_CODE_LANE_TX			0x0A28
#define USB43DP_QSERDES_TXB_RES_CODE_LANE_RX			0x0A2C
#define USB43DP_QSERDES_TXB_RES_CODE_LANE_OFFSET_TX		0x0A30
#define USB43DP_QSERDES_TXB_RES_CODE_LANE_OFFSET_RX		0x0A34
#define USB43DP_QSERDES_TXB_PERL_LENGTH1			0x0A38
#define USB43DP_QSERDES_TXB_PERL_LENGTH2			0x0A3C
#define USB43DP_QSERDES_TXB_SERDES_BYP_EN_OUT			0x0A40
#define USB43DP_QSERDES_TXB_DEBUG_BUS_SEL			0x0A44
#define USB43DP_QSERDES_TXB_TRANSCEIVER_BIAS_EN			0x0A48
#define USB43DP_QSERDES_TXB_HIGHZ_DRVR_EN			0x0A4C
#define USB43DP_QSERDES_TXB_TX_POL_INV				0x0A50
#define USB43DP_QSERDES_TXB_PARRATE_REC_DETECT_IDLE_EN		0x0A54
#define USB43DP_QSERDES_TXB_BIST_PATTERN1			0x0A58
#define USB43DP_QSERDES_TXB_BIST_PATTERN2			0x0A5C
#define USB43DP_QSERDES_TXB_BIST_PATTERN3			0x0A60
#define USB43DP_QSERDES_TXB_BIST_PATTERN4			0x0A64
#define USB43DP_QSERDES_TXB_BIST_PATTERN5			0x0A68
#define USB43DP_QSERDES_TXB_BIST_PATTERN6			0x0A6C
#define USB43DP_QSERDES_TXB_BIST_PATTERN7			0x0A70
#define USB43DP_QSERDES_TXB_BIST_PATTERN8			0x0A74
#define USB43DP_QSERDES_TXB_LANE_MODE_1				0x0A78
#define USB43DP_QSERDES_TXB_LANE_MODE_2				0x0A7C
#define USB43DP_QSERDES_TXB_LANE_MODE_3				0x0A80
#define USB43DP_QSERDES_TXB_ATB_SEL1				0x0A84
#define USB43DP_QSERDES_TXB_ATB_SEL2				0x0A88
#define USB43DP_QSERDES_TXB_RCV_DETECT_LVL			0x0A8C
#define USB43DP_QSERDES_TXB_RCV_DETECT_LVL_2			0x0A90
#define USB43DP_QSERDES_TXB_PRBS_SEED1				0x0A94
#define USB43DP_QSERDES_TXB_PRBS_SEED2				0x0A98
#define USB43DP_QSERDES_TXB_PRBS_SEED3				0x0A9C
#define USB43DP_QSERDES_TXB_PRBS_SEED4				0x0AA0
#define USB43DP_QSERDES_TXB_RESET_GEN				0x0AA4
#define USB43DP_QSERDES_TXB_RESET_GEN_MUXES			0x0AA8
#define USB43DP_QSERDES_TXB_TRAN_DRVR_EMP_EN			0x0AAC
#define USB43DP_QSERDES_TXB_VMODE_CTRL1				0x0AB0
#define USB43DP_QSERDES_TXB_ALOG_OBSV_BUS_CTRL_1		0x0AB4
#define USB43DP_QSERDES_TXB_BIST_STATUS				0x0AB8
#define USB43DP_QSERDES_TXB_BIST_ERROR_COUNT1			0x0ABC
#define USB43DP_QSERDES_TXB_BIST_ERROR_COUNT2			0x0AC0
#define USB43DP_QSERDES_TXB_ALOG_OBSV_BUS_STATUS_1		0x0AC4
#define USB43DP_QSERDES_TXB_LANE_DIG_CONFIG			0x0AC8
#define USB43DP_QSERDES_TXB_PI_QEC_CTRL				0x0ACC
#define USB43DP_QSERDES_TXB_PRE_EMPH				0x0AD0
#define USB43DP_QSERDES_TXB_SW_RESET				0x0AD4
#define USB43DP_QSERDES_TXB_TX_BAND				0x0AD8
#define USB43DP_QSERDES_TXB_SLEW_CNTL0				0x0ADC
#define USB43DP_QSERDES_TXB_SLEW_CNTL1				0x0AE0
#define USB43DP_QSERDES_TXB_INTERFACE_SELECT			0x0AE4
#define USB43DP_QSERDES_TXB_DIG_BKUP_CTRL			0x0AE8
#define USB43DP_QSERDES_TXB_DEBUG_BUS0				0x0AEC
#define USB43DP_QSERDES_TXB_DEBUG_BUS1				0x0AF0
#define USB43DP_QSERDES_TXB_DEBUG_BUS2				0x0AF4
#define USB43DP_QSERDES_TXB_DEBUG_BUS3				0x0AF8
#define USB43DP_QSERDES_TXB_TX_BKUP_RO_BUS			0x0AFC

/* Module: USB43DP_QSERDES_RXB_USB43DP_QSERDES_RXB_USB4_USB3_DP_QMP_RX */
#define USB43DP_QSERDES_RXB_UCDR_FASTLOCK_FO_GAIN_RATE0		0x0C00
#define USB43DP_QSERDES_RXB_UCDR_FASTLOCK_FO_GAIN_RATE1		0x0C04
#define USB43DP_QSERDES_RXB_UCDR_FASTLOCK_FO_GAIN_RATE2		0x0C08
#define USB43DP_QSERDES_RXB_UCDR_FASTLOCK_FO_GAIN_RATE3		0x0C0C
#define USB43DP_QSERDES_RXB_UCDR_FASTLOCK_SO_GAIN_RATE0		0x0C10
#define USB43DP_QSERDES_RXB_UCDR_FASTLOCK_SO_GAIN_RATE1		0x0C14
#define USB43DP_QSERDES_RXB_UCDR_FASTLOCK_SO_GAIN_RATE2		0x0C18
#define USB43DP_QSERDES_RXB_UCDR_FASTLOCK_SO_GAIN_RATE3		0x0C1C
#define USB43DP_QSERDES_RXB_UCDR_SO_SATURATION			0x0C20
#define USB43DP_QSERDES_RXB_UCDR_FO_TO_SO_DELAY			0x0C24
#define USB43DP_QSERDES_RXB_UCDR_FASTLOCK_COUNT_LOW_RATE0	0x0C28
#define USB43DP_QSERDES_RXB_UCDR_FASTLOCK_COUNT_HIGH_RATE0	0x0C2C
#define USB43DP_QSERDES_RXB_UCDR_FASTLOCK_COUNT_LOW_RATE1	0x0C30
#define USB43DP_QSERDES_RXB_UCDR_FASTLOCK_COUNT_HIGH_RATE1	0x0C34
#define USB43DP_QSERDES_RXB_UCDR_FASTLOCK_COUNT_LOW_RATE2	0x0C38
#define USB43DP_QSERDES_RXB_UCDR_FASTLOCK_COUNT_HIGH_RATE2	0x0C3C
#define USB43DP_QSERDES_RXB_UCDR_FASTLOCK_COUNT_LOW_RATE3	0x0C40
#define USB43DP_QSERDES_RXB_UCDR_FASTLOCK_COUNT_HIGH_RATE3	0x0C44
#define USB43DP_QSERDES_RXB_UCDR_PI_CTRL1			0x0C48
#define USB43DP_QSERDES_RXB_UCDR_PI_CTRL2			0x0C4C
#define USB43DP_QSERDES_RXB_UCDR_SB2_THRESH1_RATE0		0x0C50
#define USB43DP_QSERDES_RXB_UCDR_SB2_THRESH1_RATE1		0x0C54
#define USB43DP_QSERDES_RXB_UCDR_SB2_THRESH1_RATE2		0x0C58
#define USB43DP_QSERDES_RXB_UCDR_SB2_THRESH1_RATE3		0x0C5C
#define USB43DP_QSERDES_RXB_UCDR_SB2_THRESH2_RATE0		0x0C60
#define USB43DP_QSERDES_RXB_UCDR_SB2_THRESH2_RATE1		0x0C64
#define USB43DP_QSERDES_RXB_UCDR_SB2_THRESH2_RATE2		0x0C68
#define USB43DP_QSERDES_RXB_UCDR_SB2_THRESH2_RATE3		0x0C6C
#define USB43DP_QSERDES_RXB_UCDR_SB2_GAIN1_RATE0		0x0C70
#define USB43DP_QSERDES_RXB_UCDR_SB2_GAIN1_RATE1		0x0C74
#define USB43DP_QSERDES_RXB_UCDR_SB2_GAIN1_RATE2		0x0C78
#define USB43DP_QSERDES_RXB_UCDR_SB2_GAIN1_RATE3		0x0C7C
#define USB43DP_QSERDES_RXB_UCDR_SB2_GAIN2_RATE0		0x0C80
#define USB43DP_QSERDES_RXB_UCDR_SB2_GAIN2_RATE1		0x0C84
#define USB43DP_QSERDES_RXB_UCDR_SB2_GAIN2_RATE2		0x0C88
#define USB43DP_QSERDES_RXB_UCDR_SB2_GAIN2_RATE3		0x0C8C
#define USB43DP_QSERDES_RXB_RXCLK_DIV2_CTRL			0x0C90
#define USB43DP_QSERDES_RXB_RX_BAND				0x0C94
#define USB43DP_QSERDES_RXB_RX_TERM_BW				0x0C98
#define USB43DP_QSERDES_RXB_UCDR_FO_GAIN_RATE0			0x0C9C
#define USB43DP_QSERDES_RXB_UCDR_FO_GAIN_RATE1			0x0CA0
#define USB43DP_QSERDES_RXB_UCDR_FO_GAIN_RATE2			0x0CA4
#define USB43DP_QSERDES_RXB_UCDR_FO_GAIN_RATE3			0x0CA8
#define USB43DP_QSERDES_RXB_UCDR_SO_GAIN_RATE0			0x0CAC
#define USB43DP_QSERDES_RXB_UCDR_SO_GAIN_RATE1			0x0CB0
#define USB43DP_QSERDES_RXB_UCDR_SO_GAIN_RATE2			0x0CB4
#define USB43DP_QSERDES_RXB_UCDR_SO_GAIN_RATE3			0x0CB8
#define USB43DP_QSERDES_RXB_UCDR_PI_CONTROLS			0x0CBC
#define USB43DP_QSERDES_RXB_UCDR_PD_DATA_FILTER_ENABLES		0x0CC0
#define USB43DP_QSERDES_RXB_UCDR_SO_ACC_DEFAULT_VAL_RATE0	0x0CC4
#define USB43DP_QSERDES_RXB_UCDR_SO_ACC_DEFAULT_VAL_RATE1	0x0CC8
#define USB43DP_QSERDES_RXB_UCDR_SO_ACC_DEFAULT_VAL_RATE2	0x0CCC
#define USB43DP_QSERDES_RXB_UCDR_SO_ACC_DEFAULT_VAL_RATE3	0x0CD0
#define USB43DP_QSERDES_RXB_AUX_CONTROL				0x0CD4
#define USB43DP_QSERDES_RXB_AUXDATA_TB				0x0CD8
#define USB43DP_QSERDES_RXB_RCLK_AUXDATA_SEL			0x0CDC
#define USB43DP_QSERDES_RXB_EOM_CTRL				0x0CE0
#define USB43DP_QSERDES_RXB_AC_JTAG_ENABLE			0x0CE4
#define USB43DP_QSERDES_RXB_AC_JTAG_INITP			0x0CE8
#define USB43DP_QSERDES_RXB_AC_JTAG_INITN			0x0CEC
#define USB43DP_QSERDES_RXB_AC_JTAG_LVL				0x0CF0
#define USB43DP_QSERDES_RXB_AC_JTAG_MODE			0x0CF4
#define USB43DP_QSERDES_RXB_AC_JTAG_RESET			0x0CF8
#define USB43DP_QSERDES_RXB_RX_RCVR_IQ_EN			0x0CFC
#define USB43DP_QSERDES_RXB_RX_Q_EN_RATES			0x0D00
#define USB43DP_QSERDES_RXB_RX_IDAC_I0_DC_OFFSETS		0x0D04
#define USB43DP_QSERDES_RXB_RX_IDAC_I0BAR_DC_OFFSETS		0x0D08
#define USB43DP_QSERDES_RXB_RX_IDAC_I1_DC_OFFSETS		0x0D0C
#define USB43DP_QSERDES_RXB_RX_IDAC_I1BAR_DC_OFFSETS		0x0D10
#define USB43DP_QSERDES_RXB_RX_IDAC_Q_DC_OFFSETS		0x0D14
#define USB43DP_QSERDES_RXB_RX_IDAC_QBAR_DC_OFFSETS		0x0D18
#define USB43DP_QSERDES_RXB_RX_IDAC_A_DC_OFFSETS		0x0D1C
#define USB43DP_QSERDES_RXB_RX_IDAC_ABAR_DC_OFFSETS		0x0D20
#define USB43DP_QSERDES_RXB_RX_IDAC_EN				0x0D24
#define USB43DP_QSERDES_RXB_RX_IDAC_ENABLES			0x0D28
#define USB43DP_QSERDES_RXB_RX_IDAC_SIGN			0x0D2C
#define USB43DP_QSERDES_RXB_RX_IVCM_CAL_CODE_OVERRIDE		0x0D30
#define USB43DP_QSERDES_RXB_RX_IVCM_CAL_CTRL1			0x0D34
#define USB43DP_QSERDES_RXB_RX_IVCM_CAL_CTRL2			0x0D38
#define USB43DP_QSERDES_RXB_RX_IVCM_POSTCAL_OFFSET		0x0D3C
#define USB43DP_QSERDES_RXB_RX_SUMMER_CAL_SPD_MODE		0x0D40
#define USB43DP_QSERDES_RXB_RX_HIGHZ_PARRATE			0x0D44
#define USB43DP_QSERDES_RXB_RX_TERM_AC_BYPASS_DC_COUPLE_OFFSET	0x0D48
#define USB43DP_QSERDES_RXB_DFE_1				0x0D4C
#define USB43DP_QSERDES_RXB_DFE_2				0x0D50
#define USB43DP_QSERDES_RXB_DFE_3				0x0D54
#define USB43DP_QSERDES_RXB_DFE_4				0x0D58
#define USB43DP_QSERDES_RXB_DFE_TAP3_CTRL			0x0D5C
#define USB43DP_QSERDES_RXB_DFE_TAP3_MANVAL_KTAP		0x0D60
#define USB43DP_QSERDES_RXB_DFE_TAP4_CTRL			0x0D64
#define USB43DP_QSERDES_RXB_DFE_TAP4_MANVAL_KTAP		0x0D68
#define USB43DP_QSERDES_RXB_DFE_TAP5_CTRL			0x0D6C
#define USB43DP_QSERDES_RXB_DFE_TAP5_MANVAL_KTAP		0x0D70
#define USB43DP_QSERDES_RXB_TX_ADPT_CTRL			0x0D74
#define USB43DP_QSERDES_RXB_DFE_DAC_ENABLE1			0x0D78
#define USB43DP_QSERDES_RXB_DFE_DAC_ENABLE2			0x0D7C
#define USB43DP_QSERDES_RXB_TX_ADAPT_PRE_THRESH1		0x0D80
#define USB43DP_QSERDES_RXB_TX_ADAPT_PRE_THRESH2		0x0D84
#define USB43DP_QSERDES_RXB_TX_ADAPT_POST_THRESH1		0x0D88
#define USB43DP_QSERDES_RXB_TX_ADAPT_POST_THRESH2		0x0D8C
#define USB43DP_QSERDES_RXB_TX_ADAPT_MAIN_THRESH1		0x0D90
#define USB43DP_QSERDES_RXB_TX_ADAPT_MAIN_THRESH2		0x0D94
#define USB43DP_QSERDES_RXB_VGA_CAL_CNTRL1			0x0D98
#define USB43DP_QSERDES_RXB_VGA_CAL_CNTRL2			0x0D9C
#define USB43DP_QSERDES_RXB_VGA_CAL_MAN_VAL			0x0DA0
#define USB43DP_QSERDES_RXB_VTHRESH_CAL_CNTRL1			0x0DA4
#define USB43DP_QSERDES_RXB_VTHRESH_CAL_CNTRL2			0x0DA8
#define USB43DP_QSERDES_RXB_VTHRESH_CAL_MAN_VAL_RATE0		0x0DAC
#define USB43DP_QSERDES_RXB_VTHRESH_CAL_MAN_VAL_RATE1		0x0DB0
#define USB43DP_QSERDES_RXB_VTHRESH_CAL_MAN_VAL_RATE2		0x0DB4
#define USB43DP_QSERDES_RXB_VTHRESH_CAL_MAN_VAL_RATE3		0x0DB8
#define USB43DP_QSERDES_RXB_GM_CAL				0x0DBC
#define USB43DP_QSERDES_RXB_RX_VGA_GAIN2_BLK1			0x0DC0
#define USB43DP_QSERDES_RXB_RX_VGA_GAIN2_BLK2			0x0DC4
#define USB43DP_QSERDES_RXB_RX_EQU_ADAPTOR_CNTRL2		0x0DC8
#define USB43DP_QSERDES_RXB_RX_EQU_ADAPTOR_CNTRL3		0x0DCC
#define USB43DP_QSERDES_RXB_RX_EQU_ADAPTOR_CNTRL4		0x0DD0
#define USB43DP_QSERDES_RXB_RX_IDAC_TSETTLE_LOW			0x0DD4
#define USB43DP_QSERDES_RXB_RX_EQ_OFFSET_LSB			0x0DD8
#define USB43DP_QSERDES_RXB_RX_EQ_OFFSET_MSB			0x0DDC
#define USB43DP_QSERDES_RXB_RX_EQ_OFFSET_ADAPTOR_CNTRL1		0x0DE0
#define USB43DP_QSERDES_RXB_RX_OFFSET_ADAPTOR_CNTRL2		0x0DE4
#define USB43DP_QSERDES_RXB_SIGDET_ENABLES			0x0DE8
#define USB43DP_QSERDES_RXB_SIGDET_CNTRL			0x0DEC
#define USB43DP_QSERDES_RXB_SIGDET_LVL				0x0DF0
#define USB43DP_QSERDES_RXB_SIGDET_DEGLITCH_CNTRL		0x0DF4
#define USB43DP_QSERDES_RXB_CDR_FREEZE_UP_DN			0x0DF8
#define USB43DP_QSERDES_RXB_CDR_RESET_OVERRIDE			0x0DFC
#define USB43DP_QSERDES_RXB_RX_INTERFACE_MODE			0x0E00
#define USB43DP_QSERDES_RXB_JITTER_GEN_MODE			0x0E04
#define USB43DP_QSERDES_RXB_SJ_AMP1				0x0E08
#define USB43DP_QSERDES_RXB_SJ_AMP2				0x0E0C
#define USB43DP_QSERDES_RXB_SJ_PER1				0x0E10
#define USB43DP_QSERDES_RXB_SJ_PER2				0x0E14
#define USB43DP_QSERDES_RXB_PPM_OFFSET1				0x0E18
#define USB43DP_QSERDES_RXB_PPM_OFFSET2				0x0E1C
#define USB43DP_QSERDES_RXB_SIGN_PPM_PERIOD1			0x0E20
#define USB43DP_QSERDES_RXB_SIGN_PPM_PERIOD2			0x0E24
#define USB43DP_QSERDES_RXB_RX_MODE_RATE_0_1_B0			0x0E28
#define USB43DP_QSERDES_RXB_RX_MODE_RATE_0_1_B1			0x0E2C
#define USB43DP_QSERDES_RXB_RX_MODE_RATE_0_1_B2			0x0E30
#define USB43DP_QSERDES_RXB_RX_MODE_RATE_0_1_B3			0x0E34
#define USB43DP_QSERDES_RXB_RX_MODE_RATE_0_1_B4			0x0E38
#define USB43DP_QSERDES_RXB_RX_MODE_RATE_0_1_B5			0x0E3C
#define USB43DP_QSERDES_RXB_RX_MODE_RATE_0_1_B6			0x0E40
#define USB43DP_QSERDES_RXB_RX_MODE_RATE_0_1_B7			0x0E44
#define USB43DP_QSERDES_RXB_RX_MODE_RATE2_B0			0x0E48
#define USB43DP_QSERDES_RXB_RX_MODE_RATE2_B1			0x0E4C
#define USB43DP_QSERDES_RXB_RX_MODE_RATE2_B2			0x0E50
#define USB43DP_QSERDES_RXB_RX_MODE_RATE2_B3			0x0E54
#define USB43DP_QSERDES_RXB_RX_MODE_RATE2_B4			0x0E58
#define USB43DP_QSERDES_RXB_RX_MODE_RATE2_B5			0x0E5C
#define USB43DP_QSERDES_RXB_RX_MODE_RATE2_B6			0x0E60
#define USB43DP_QSERDES_RXB_RX_MODE_RATE2_B7			0x0E64
#define USB43DP_QSERDES_RXB_RX_MODE_RATE3_B0			0x0E68
#define USB43DP_QSERDES_RXB_RX_MODE_RATE3_B1			0x0E6C
#define USB43DP_QSERDES_RXB_RX_MODE_RATE3_B2			0x0E70
#define USB43DP_QSERDES_RXB_RX_MODE_RATE3_B3			0x0E74
#define USB43DP_QSERDES_RXB_RX_MODE_RATE3_B4			0x0E78
#define USB43DP_QSERDES_RXB_RX_MODE_RATE3_B5			0x0E7C
#define USB43DP_QSERDES_RXB_RX_MODE_RATE3_B6			0x0E80
#define USB43DP_QSERDES_RXB_RX_MODE_RATE3_B7			0x0E84
#define USB43DP_QSERDES_RXB_PHPRE_CTRL				0x0E88
#define USB43DP_QSERDES_RXB_PHPRE_INITVAL			0x0E8C
#define USB43DP_QSERDES_RXB_DFE_EN_TIMER			0x0E90
#define USB43DP_QSERDES_RXB_DFE_CTLE_POST_CAL_OFFSET		0x0E94
#define USB43DP_QSERDES_RXB_DCC_CTRL1				0x0E98
#define USB43DP_QSERDES_RXB_DCC_CTRL2				0x0E9C
#define USB43DP_QSERDES_RXB_DCC_OFFSET				0x0EA0
#define USB43DP_QSERDES_RXB_DCC_CMUX_POSTCAL_OFFSET		0x0EA4
#define USB43DP_QSERDES_RXB_DCC_CMUX_CAL_CTRL1			0x0EA8
#define USB43DP_QSERDES_RXB_DCC_CMUX_CAL_CTRL2			0x0EAC
#define USB43DP_QSERDES_RXB_ALOG_OBSV_BUS_CTRL_1		0x0EB0
#define USB43DP_QSERDES_RXB_RX_MARG_CTRL1			0x0EB4
#define USB43DP_QSERDES_RXB_RX_MARG_CTRL2			0x0EB8
#define USB43DP_QSERDES_RXB_RX_MARG_CTRL3			0x0EBC
#define USB43DP_QSERDES_RXB_RX_MARG_CTRL_4			0x0EC0
#define USB43DP_QSERDES_RXB_RX_MARG_CFG_RATE_0_1		0x0EC4
#define USB43DP_QSERDES_RXB_RX_MARG_CFG_RATE_2_3		0x0EC8
#define USB43DP_QSERDES_RXB_RX_MARG_COARSE_CTRL1		0x0ECC
#define USB43DP_QSERDES_RXB_RX_MARG_COARSE_CTRL2		0x0ED0
#define USB43DP_QSERDES_RXB_RX_MARG_COARSE_THRESH1_RATE210	0x0ED4
#define USB43DP_QSERDES_RXB_RX_MARG_COARSE_THRESH1_RATE3	0x0ED8
#define USB43DP_QSERDES_RXB_RX_MARG_COARSE_THRESH2_RATE210	0x0EDC
#define USB43DP_QSERDES_RXB_RX_MARG_COARSE_THRESH2_RATE3	0x0EE0
#define USB43DP_QSERDES_RXB_RX_MARG_COARSE_THRESH3_RATE210	0x0EE4
#define USB43DP_QSERDES_RXB_RX_MARG_COARSE_THRESH3_RATE3	0x0EE8
#define USB43DP_QSERDES_RXB_RX_MARG_COARSE_THRESH4_RATE210	0x0EEC
#define USB43DP_QSERDES_RXB_RX_MARG_COARSE_THRESH4_RATE3	0x0EF0
#define USB43DP_QSERDES_RXB_RX_MARG_COARSE_THRESH5_RATE210	0x0EF4
#define USB43DP_QSERDES_RXB_RX_MARG_COARSE_THRESH5_RATE3	0x0EF8
#define USB43DP_QSERDES_RXB_RX_MARG_COARSE_THRESH6_RATE210	0x0EFC
#define USB43DP_QSERDES_RXB_RX_MARG_COARSE_THRESH6_RATE3	0x0F00
#define USB43DP_QSERDES_RXB_RX_MARG_COARSE_THRESH7_RATE210	0x0F04
#define USB43DP_QSERDES_RXB_RX_MARG_COARSE_THRESH7_RATE3	0x0F08
#define USB43DP_QSERDES_RXB_Q_PI_INTRINSIC_BIAS_RATE10		0x0F0C
#define USB43DP_QSERDES_RXB_Q_PI_INTRINSIC_BIAS_RATE32		0x0F10
#define USB43DP_QSERDES_RXB_RX_MARG_VERTICAL_CTRL		0x0F14
#define USB43DP_QSERDES_RXB_RX_MARG_VERTICAL_CODE		0x0F18
#define USB43DP_QSERDES_RXB_RES_CODE_THRESH_HIGH_AND_BYP	0x0F1C
#define USB43DP_QSERDES_RXB_RES_CODE_THRESH_LOW			0x0F20
#define USB43DP_QSERDES_RXB_RX_BKUP_CTRL1			0x0F24
#define USB43DP_QSERDES_RXB_RX_BKUP_CTRL2			0x0F28
#define USB43DP_QSERDES_RXB_RX_BKUP_CTRL3			0x0F2C
#define USB43DP_QSERDES_RXB_PI_CTRL1				0x0F30
#define USB43DP_QSERDES_RXB_PI_CTRL2				0x0F34
#define USB43DP_QSERDES_RXB_PI_QUAD				0x0F38
#define USB43DP_QSERDES_RXB_QPI_CTRL1				0x0F3C
#define USB43DP_QSERDES_RXB_QPI_CTRL2				0x0F40
#define USB43DP_QSERDES_RXB_QPI_QUAD				0x0F44
#define USB43DP_QSERDES_RXB_IDATA1				0x0F48
#define USB43DP_QSERDES_RXB_IDATA2				0x0F4C
#define USB43DP_QSERDES_RXB_IDATA3				0x0F50
#define USB43DP_QSERDES_RXB_AC_JTAG_OUTP			0x0F54
#define USB43DP_QSERDES_RXB_AC_JTAG_OUTN			0x0F58
#define USB43DP_QSERDES_RXB_RX_SIGDET				0x0F5C
#define USB43DP_QSERDES_RXB_ALOG_OBSV_BUS_STATUS_1		0x0F60
#define USB43DP_QSERDES_RXB_READ_EQCODE				0x0F64
#define USB43DP_QSERDES_RXB_READ_OFFSETCODE			0x0F68
#define USB43DP_QSERDES_RXB_IA_ERROR_COUNTER_LOW		0x0F6C
#define USB43DP_QSERDES_RXB_IA_ERROR_COUNTER_HIGH		0x0F70
#define USB43DP_QSERDES_RXB_VGA_READ_CODE			0x0F74
#define USB43DP_QSERDES_RXB_VTHRESH_READ_CODE			0x0F78
#define USB43DP_QSERDES_RXB_DFE_TAP1_READ_CODE			0x0F7C
#define USB43DP_QSERDES_RXB_DFE_TAP2_READ_CODE			0x0F80
#define USB43DP_QSERDES_RXB_DFE_TAP3_READ_CODE			0x0F84
#define USB43DP_QSERDES_RXB_DFE_TAP4_READ_CODE			0x0F88
#define USB43DP_QSERDES_RXB_DFE_TAP5_READ_CODE			0x0F8C
#define USB43DP_QSERDES_RXB_IDAC_STATUS_I0			0x0F90
#define USB43DP_QSERDES_RXB_IDAC_STATUS_I0BAR			0x0F94
#define USB43DP_QSERDES_RXB_IDAC_STATUS_I1			0x0F98
#define USB43DP_QSERDES_RXB_IDAC_STATUS_I1BAR			0x0F9C
#define USB43DP_QSERDES_RXB_IDAC_STATUS_Q			0x0FA0
#define USB43DP_QSERDES_RXB_IDAC_STATUS_QBAR			0x0FA4
#define USB43DP_QSERDES_RXB_IDAC_STATUS_A			0x0FA8
#define USB43DP_QSERDES_RXB_IDAC_STATUS_ABAR			0x0FAC
#define USB43DP_QSERDES_RXB_IDAC_STATUS_SM_ON			0x0FB0
#define USB43DP_QSERDES_RXB_IDAC_STATUS_SIGNERROR		0x0FB4
#define USB43DP_QSERDES_RXB_IVCM_CAL_STATUS			0x0FB8
#define USB43DP_QSERDES_RXB_IVCM_CAL_DEBUG_STATUS		0x0FBC
#define USB43DP_QSERDES_RXB_DCC_CAL_STATUS			0x0FC0
#define USB43DP_QSERDES_RXB_DCC_READ_CODE_STATUS		0x0FC4
#define USB43DP_QSERDES_RXB_RX_MARG_DEBUG1_STATUS		0x0FC8
#define USB43DP_QSERDES_RXB_RX_MARG_DEBUG2_STATUS		0x0FCC
#define USB43DP_QSERDES_RXB_RX_MARG_READ_CODE_STATUS		0x0FD0
#define USB43DP_QSERDES_RXB_EOM_ERR_CNT_LSB_STATUS		0x0FD4
#define USB43DP_QSERDES_RXB_EOM_ERR_CNT_MSB_STATUS		0x0FD8
#define USB43DP_QSERDES_RXB_RX_MARG_COARSE_TUNE_STATUS		0x0FDC
#define USB43DP_QSERDES_RXB_RX_BKUP_READ_BUS1_STATUS		0x0FE0
#define USB43DP_QSERDES_RXB_RX_BKUP_READ_BUS2_STATUS		0x0FE4
#define USB43DP_QSERDES_RXB_RX_BKUP_READ_BUS3_STATUS		0x0FE8

/* Module: USB3_QSERDES_PLL_USB3_QSERDES_PLL_USB4_USB3_DP_QMP_PLL_20G */
#define USB3_QSERDES_PLL_ATB_SEL1				0x1000
#define USB3_QSERDES_PLL_ATB_SEL2				0x1004
#define USB3_QSERDES_PLL_FREQ_UPDATE				0x1008
#define USB3_QSERDES_PLL_BG_TIMER				0x100C
#define USB3_QSERDES_PLL_SSC_EN_CENTER				0x1010
#define USB3_QSERDES_PLL_SSC_ADJ_PER1				0x1014
#define USB3_QSERDES_PLL_SSC_ADJ_PER2				0x1018
#define USB3_QSERDES_PLL_SSC_PER1				0x101C
#define USB3_QSERDES_PLL_SSC_PER2				0x1020
#define USB3_QSERDES_PLL_SSC_STEP_SIZE1_MODE0			0x1024
#define USB3_QSERDES_PLL_SSC_STEP_SIZE2_MODE0			0x1028
#define USB3_QSERDES_PLL_SSC_STEP_SIZE3_MODE0			0x102C
#define USB3_QSERDES_PLL_SSC_STEP_SIZE1_MODE1			0x1030
#define USB3_QSERDES_PLL_SSC_STEP_SIZE2_MODE1			0x1034
#define USB3_QSERDES_PLL_SSC_STEP_SIZE3_MODE1			0x1038
#define USB3_QSERDES_PLL_POST_DIV				0x103C
#define USB3_QSERDES_PLL_POST_DIV_MUX				0x1040
#define USB3_QSERDES_PLL_BIAS_EN_CLKBUFLR_EN			0x1044
#define USB3_QSERDES_PLL_CLK_ENABLE1				0x1048
#define USB3_QSERDES_PLL_SYS_CLK_CTRL				0x104C
#define USB3_QSERDES_PLL_SYSCLK_BUF_ENABLE			0x1050
#define USB3_QSERDES_PLL_PLL_EN					0x1054
#define USB3_QSERDES_PLL_PLL_IVCO				0x1058
#define USB3_QSERDES_PLL_CMN_IETRIM				0x105C
#define USB3_QSERDES_PLL_CMN_IPTRIM				0x1060
#define USB3_QSERDES_PLL_EP_CLOCK_DETECT_CTRL			0x1064
#define USB3_QSERDES_PLL_SYSCLK_DET_COMP_STATUS			0x1068
#define USB3_QSERDES_PLL_CLK_EP_DIV_MODE0			0x106C
#define USB3_QSERDES_PLL_CLK_EP_DIV_MODE1			0x1070
#define USB3_QSERDES_PLL_CP_CTRL_MODE0				0x1074
#define USB3_QSERDES_PLL_CP_CTRL_MODE1				0x1078
#define USB3_QSERDES_PLL_PLL_RCTRL_MODE0			0x107C
#define USB3_QSERDES_PLL_PLL_RCTRL_MODE1			0x1080
#define USB3_QSERDES_PLL_PLL_CCTRL_MODE0			0x1084
#define USB3_QSERDES_PLL_PLL_CCTRL_MODE1			0x1088
#define USB3_QSERDES_PLL_PLL_CNTRL				0x108C
#define USB3_QSERDES_PLL_BIAS_EN_CTRL_BY_PSM			0x1090
#define USB3_QSERDES_PLL_SYSCLK_EN_SEL				0x1094
#define USB3_QSERDES_PLL_CML_SYSCLK_SEL				0x1098
#define USB3_QSERDES_PLL_RESETSM_CNTRL				0x109C
#define USB3_QSERDES_PLL_RESETSM_CNTRL2				0x10A0
#define USB3_QSERDES_PLL_LOCK_CMP_EN				0x10A4
#define USB3_QSERDES_PLL_LOCK_CMP_CFG				0x10A8
#define USB3_QSERDES_PLL_LOCK_CMP1_MODE0			0x10AC
#define USB3_QSERDES_PLL_LOCK_CMP2_MODE0			0x10B0
#define USB3_QSERDES_PLL_LOCK_CMP1_MODE1			0x10B4
#define USB3_QSERDES_PLL_LOCK_CMP2_MODE1			0x10B8
#define USB3_QSERDES_PLL_DEC_START_MODE0			0x10BC
#define USB3_QSERDES_PLL_DEC_START_MSB_MODE0			0x10C0
#define USB3_QSERDES_PLL_DEC_START_MODE1			0x10C4
#define USB3_QSERDES_PLL_DEC_START_MSB_MODE1			0x10C8
#define USB3_QSERDES_PLL_DIV_FRAC_START1_MODE0			0x10CC
#define USB3_QSERDES_PLL_DIV_FRAC_START2_MODE0			0x10D0
#define USB3_QSERDES_PLL_DIV_FRAC_START3_MODE0			0x10D4
#define USB3_QSERDES_PLL_DIV_FRAC_START1_MODE1			0x10D8
#define USB3_QSERDES_PLL_DIV_FRAC_START2_MODE1			0x10DC
#define USB3_QSERDES_PLL_DIV_FRAC_START3_MODE1			0x10E0
#define USB3_QSERDES_PLL_INTEGLOOP_INITVAL			0x10E4
#define USB3_QSERDES_PLL_INTEGLOOP_EN				0x10E8
#define USB3_QSERDES_PLL_INTEGLOOP_GAIN0_MODE0			0x10EC
#define USB3_QSERDES_PLL_INTEGLOOP_GAIN1_MODE0			0x10F0
#define USB3_QSERDES_PLL_INTEGLOOP_GAIN0_MODE1			0x10F4
#define USB3_QSERDES_PLL_INTEGLOOP_GAIN1_MODE1			0x10F8
#define USB3_QSERDES_PLL_INTEGLOOP_P_PATH_GAIN0			0x10FC
#define USB3_QSERDES_PLL_INTEGLOOP_P_PATH_GAIN1			0x1100
#define USB3_QSERDES_PLL_VCOCAL_DEADMAN_CTRL			0x1104
#define USB3_QSERDES_PLL_VCO_TUNE_CTRL				0x1108
#define USB3_QSERDES_PLL_VCO_TUNE_MAP				0x110C
#define USB3_QSERDES_PLL_VCO_TUNE1_MODE0			0x1110
#define USB3_QSERDES_PLL_VCO_TUNE2_MODE0			0x1114
#define USB3_QSERDES_PLL_VCO_TUNE1_MODE1			0x1118
#define USB3_QSERDES_PLL_VCO_TUNE2_MODE1			0x111C
#define USB3_QSERDES_PLL_VCO_TUNE_INITVAL1			0x1120
#define USB3_QSERDES_PLL_VCO_TUNE_INITVAL2			0x1124
#define USB3_QSERDES_PLL_VCO_TUNE_MINVAL1			0x1128
#define USB3_QSERDES_PLL_VCO_TUNE_MINVAL2			0x112C
#define USB3_QSERDES_PLL_VCO_TUNE_MAXVAL1			0x1130
#define USB3_QSERDES_PLL_VCO_TUNE_MAXVAL2			0x1134
#define USB3_QSERDES_PLL_VCO_TUNE_TIMER1			0x1138
#define USB3_QSERDES_PLL_VCO_TUNE_TIMER2			0x113C
#define USB3_QSERDES_PLL_CMN_STATUS				0x1140
#define USB3_QSERDES_PLL_RESET_SM_STATUS			0x1144
#define USB3_QSERDES_PLL_RESTRIM_CODE_STATUS			0x1148
#define USB3_QSERDES_PLL_PLLCAL_CODE1_STATUS			0x114C
#define USB3_QSERDES_PLL_PLLCAL_CODE2_STATUS			0x1150
#define USB3_QSERDES_PLL_CLK_SELECT				0x1154
#define USB3_QSERDES_PLL_HSCLK_SEL				0x1158
#define USB3_QSERDES_PLL_HSCLK_HS_SWITCH_SEL			0x115C
#define USB3_QSERDES_PLL_INTEGLOOP_BINCODE_STATUS		0x1160
#define USB3_QSERDES_PLL_PLL_ANALOG				0x1164
#define USB3_QSERDES_PLL_CORECLK_DIV_MODE0			0x1168
#define USB3_QSERDES_PLL_CORECLK_DIV_MODE1			0x116C
#define USB3_QSERDES_PLL_SW_RESET				0x1170
#define USB3_QSERDES_PLL_CORE_CLK_EN				0x1174
#define USB3_QSERDES_PLL_C_READY_STATUS				0x1178
#define USB3_QSERDES_PLL_CMN_CONFIG				0x117C
#define USB3_QSERDES_PLL_CMN_RATE_OVERRIDE			0x1180
#define USB3_QSERDES_PLL_SVS_MODE_CLK_SEL			0x1184
#define USB3_QSERDES_PLL_DEBUG_BUS0				0x1188
#define USB3_QSERDES_PLL_DEBUG_BUS1				0x118C
#define USB3_QSERDES_PLL_DEBUG_BUS2				0x1190
#define USB3_QSERDES_PLL_DEBUG_BUS3				0x1194
#define USB3_QSERDES_PLL_DEBUG_BUS_SEL				0x1198
#define USB3_QSERDES_PLL_CMN_MISC1				0x119C
#define USB3_QSERDES_PLL_CMN_MODE				0x11A0
#define USB3_QSERDES_PLL_CMN_MODE_CONTD				0x11A4
#define USB3_QSERDES_PLL_VCO_DC_LEVEL_CTRL			0x11A8
#define USB3_QSERDES_PLL_BIN_VCOCAL_CMP_CODE1_MODE0		0x11AC
#define USB3_QSERDES_PLL_BIN_VCOCAL_CMP_CODE2_MODE0		0x11B0
#define USB3_QSERDES_PLL_BIN_VCOCAL_CMP_CODE1_MODE1		0x11B4
#define USB3_QSERDES_PLL_BIN_VCOCAL_CMP_CODE2_MODE1		0x11B8
#define USB3_QSERDES_PLL_BIN_VCOCAL_HSCLK_SEL			0x11BC
#define USB3_QSERDES_PLL_ADDITIONAL_CTRL_1			0x11C0
#define USB3_QSERDES_PLL_MODE_OPERATION_STATUS			0x11C4
#define USB3_QSERDES_PLL_AUTO_GAIN_ADJ_CTRL_1			0x11C8
#define USB3_QSERDES_PLL_AUTO_GAIN_ADJ_CTRL_2			0x11CC
#define USB3_QSERDES_PLL_AUTO_GAIN_ADJ_CTRL_3			0x11D0
#define USB3_QSERDES_PLL_AUTO_GAIN_ADJ_CTRL_4			0x11D4
#define USB3_QSERDES_PLL_ADDITIONAL_MISC			0x11D8
#define USB3_QSERDES_PLL_ADDITIONAL_MISC_2			0x11DC
#define USB3_QSERDES_PLL_ADDITIONAL_MISC_3			0x11E0

/* Module: USB3_PCS_MISC_USB3_PCS_MISC_USB3_PCS_MISC */
#define USB3_PCS_MISC_TYPEC_CTRL				0x1200
#define USB3_PCS_MISC_TYPEC_PWRDN_CTRL				0x1204
#define USB3_PCS_MISC_PCS_MISC_CONFIG1				0x1208
#define USB3_PCS_MISC_CLAMP_ENABLE				0x120C
#define USB3_PCS_MISC_TYPEC_STATUS				0x1210
#define USB3_PCS_MISC_PLACEHOLDER_STATUS			0x1214

/* Module: USB3_PCS_LN_USB3_PCS_LN_USB3_PCS_LANE */
#define USB3_PCS_LN_PCS_STATUS1					0x1300
#define USB3_PCS_LN_PCS_STATUS2					0x1304
#define USB3_PCS_LN_PCS_STATUS2_CLEAR				0x1308
#define USB3_PCS_LN_PCS_STATUS3					0x130C
#define USB3_PCS_LN_BIST_CHK_ERR_CNT_L_STATUS			0x1310
#define USB3_PCS_LN_BIST_CHK_ERR_CNT_H_STATUS			0x1314
#define USB3_PCS_LN_BIST_CHK_STATUS				0x1318
#define USB3_PCS_LN_INSIG_SW_CTRL1				0x131C
#define USB3_PCS_LN_INSIG_MX_CTRL1				0x1320
#define USB3_PCS_LN_OUTSIG_SW_CTRL1				0x1324
#define USB3_PCS_LN_OUTSIG_MX_CTRL1				0x1328
#define USB3_PCS_LN_TEST_CONTROL1				0x132C
#define USB3_PCS_LN_BIST_CTRL					0x1330
#define USB3_PCS_LN_PRBS_SEED0					0x1334
#define USB3_PCS_LN_PRBS_SEED1					0x1338
#define USB3_PCS_LN_FIXED_PAT_CTRL				0x133C
#define USB3_PCS_LN_EQ_CONFIG					0x1340
#define USB3_PCS_LN_TEST_CONTROL2				0x1344
#define USB3_PCS_LN_TEST_CONTROL3				0x1348

/* Module: USB3_PCS_USB3_PCS_USB3_PCS */
#define USB3_PCS_SW_RESET					0x1400
#define USB3_PCS_REVISION_ID0					0x1404
#define USB3_PCS_REVISION_ID1					0x1408
#define USB3_PCS_REVISION_ID2					0x140C
#define USB3_PCS_REVISION_ID3					0x1410
#define USB3_PCS_PCS_STATUS1					0x1414
#define USB3_PCS_PCS_STATUS2					0x1418
#define USB3_PCS_PCS_STATUS3					0x141C
#define USB3_PCS_PCS_STATUS4					0x1420
#define USB3_PCS_PCS_STATUS5					0x1424
#define USB3_PCS_PCS_STATUS6					0x1428
#define USB3_PCS_PCS_STATUS7					0x142C
#define USB3_PCS_DEBUG_BUS_0_STATUS				0x1430
#define USB3_PCS_DEBUG_BUS_1_STATUS				0x1434
#define USB3_PCS_DEBUG_BUS_2_STATUS				0x1438
#define USB3_PCS_DEBUG_BUS_3_STATUS				0x143C
#define USB3_PCS_POWER_DOWN_CONTROL				0x1440
#define USB3_PCS_START_CONTROL					0x1444
#define USB3_PCS_INSIG_SW_CTRL1					0x1448
#define USB3_PCS_INSIG_SW_CTRL2					0x144C
#define USB3_PCS_INSIG_SW_CTRL3					0x1450
#define USB3_PCS_INSIG_SW_CTRL4					0x1454
#define USB3_PCS_INSIG_SW_CTRL5					0x1458
#define USB3_PCS_INSIG_SW_CTRL6					0x145C
#define USB3_PCS_INSIG_SW_CTRL7					0x1460
#define USB3_PCS_INSIG_SW_CTRL8					0x1464
#define USB3_PCS_INSIG_MX_CTRL1					0x1468
#define USB3_PCS_INSIG_MX_CTRL2					0x146C
#define USB3_PCS_INSIG_MX_CTRL3					0x1470
#define USB3_PCS_INSIG_MX_CTRL4					0x1474
#define USB3_PCS_INSIG_MX_CTRL5					0x1478
#define USB3_PCS_INSIG_MX_CTRL7					0x147C
#define USB3_PCS_INSIG_MX_CTRL8					0x1480
#define USB3_PCS_OUTSIG_SW_CTRL1				0x1484
#define USB3_PCS_OUTSIG_MX_CTRL1				0x1488
#define USB3_PCS_CLAMP_ENABLE					0x148C
#define USB3_PCS_POWER_STATE_CONFIG1				0x1490
#define USB3_PCS_POWER_STATE_CONFIG2				0x1494
#define USB3_PCS_FLL_CNTRL1					0x1498
#define USB3_PCS_FLL_CNTRL2					0x149C
#define USB3_PCS_FLL_CNT_VAL_L					0x14A0
#define USB3_PCS_FLL_CNT_VAL_H_TOL				0x14A4
#define USB3_PCS_FLL_MAN_CODE					0x14A8
#define USB3_PCS_TEST_CONTROL1					0x14AC
#define USB3_PCS_TEST_CONTROL2					0x14B0
#define USB3_PCS_TEST_CONTROL3					0x14B4
#define USB3_PCS_TEST_CONTROL4					0x14B8
#define USB3_PCS_TEST_CONTROL5					0x14BC
#define USB3_PCS_TEST_CONTROL6					0x14C0
#define USB3_PCS_LOCK_DETECT_CONFIG1				0x14C4
#define USB3_PCS_LOCK_DETECT_CONFIG2				0x14C8
#define USB3_PCS_LOCK_DETECT_CONFIG3				0x14CC
#define USB3_PCS_LOCK_DETECT_CONFIG4				0x14D0
#define USB3_PCS_LOCK_DETECT_CONFIG5				0x14D4
#define USB3_PCS_LOCK_DETECT_CONFIG6				0x14D8
#define USB3_PCS_REFGEN_REQ_CONFIG1				0x14DC
#define USB3_PCS_REFGEN_REQ_CONFIG2				0x14E0
#define USB3_PCS_REFGEN_REQ_CONFIG3				0x14E4
#define USB3_PCS_BIST_CTRL					0x14E8
#define USB3_PCS_PRBS_POLY0					0x14EC
#define USB3_PCS_PRBS_POLY1					0x14F0
#define USB3_PCS_FIXED_PAT0					0x14F4
#define USB3_PCS_FIXED_PAT1					0x14F8
#define USB3_PCS_FIXED_PAT2					0x14FC
#define USB3_PCS_FIXED_PAT3					0x1500
#define USB3_PCS_FIXED_PAT4					0x1504
#define USB3_PCS_FIXED_PAT5					0x1508
#define USB3_PCS_FIXED_PAT6					0x150C
#define USB3_PCS_FIXED_PAT7					0x1510
#define USB3_PCS_FIXED_PAT8					0x1514
#define USB3_PCS_FIXED_PAT9					0x1518
#define USB3_PCS_FIXED_PAT10					0x151C
#define USB3_PCS_FIXED_PAT11					0x1520
#define USB3_PCS_FIXED_PAT12					0x1524
#define USB3_PCS_FIXED_PAT13					0x1528
#define USB3_PCS_FIXED_PAT14					0x152C
#define USB3_PCS_FIXED_PAT15					0x1530
#define USB3_PCS_TXMGN_CONFIG					0x1534
#define USB3_PCS_G12S1_TXMGN_V0					0x1538
#define USB3_PCS_G12S1_TXMGN_V1					0x153C
#define USB3_PCS_G12S1_TXMGN_V2					0x1540
#define USB3_PCS_G12S1_TXMGN_V3					0x1544
#define USB3_PCS_G12S1_TXMGN_V4					0x1548
#define USB3_PCS_G12S1_TXMGN_V0_RS				0x154C
#define USB3_PCS_G12S1_TXMGN_V1_RS				0x1550
#define USB3_PCS_G12S1_TXMGN_V2_RS				0x1554
#define USB3_PCS_G12S1_TXMGN_V3_RS				0x1558
#define USB3_PCS_G12S1_TXMGN_V4_RS				0x155C
#define USB3_PCS_G3S2_TXMGN_MAIN				0x1560
#define USB3_PCS_G3S2_TXMGN_MAIN_RS				0x1564
#define USB3_PCS_G12S1_TXDEEMPH_M6DB				0x1568
#define USB3_PCS_G12S1_TXDEEMPH_M3P5DB				0x156C
#define USB3_PCS_G3S2_PRE_GAIN					0x1570
#define USB3_PCS_G3S2_POST_GAIN					0x1574
#define USB3_PCS_G3S2_PRE_POST_OFFSET				0x1578
#define USB3_PCS_G3S2_PRE_GAIN_RS				0x157C
#define USB3_PCS_G3S2_POST_GAIN_RS				0x1580
#define USB3_PCS_G3S2_PRE_POST_OFFSET_RS			0x1584
#define USB3_PCS_RX_SIGDET_LVL					0x1588
#define USB3_PCS_RX_SIGDET_DTCT_CNTRL				0x158C
#define USB3_PCS_RCVR_DTCT_DLY_P1U2_L				0x1590
#define USB3_PCS_RCVR_DTCT_DLY_P1U2_H				0x1594
#define USB3_PCS_RATE_SLEW_CNTRL1				0x1598
#define USB3_PCS_RATE_SLEW_CNTRL2				0x159C
#define USB3_PCS_PWRUP_RESET_DLY_TIME_AUXCLK			0x15A0
#define USB3_PCS_P2U3_WAKEUP_DLY_TIME_AUXCLK_L			0x15A4
#define USB3_PCS_P2U3_WAKEUP_DLY_TIME_AUXCLK_H			0x15A8
#define USB3_PCS_TSYNC_RSYNC_TIME				0x15AC
#define USB3_PCS_RX_CONFIG					0x15B0
#define USB3_PCS_TSYNC_DLY_TIME					0x15B4
#define USB3_PCS_ELECIDLE_DLY_SEL				0x15B8
#define USB3_PCS_CMN_ACK_OUT_SEL				0x15BC
#define USB3_PCS_ALIGN_DETECT_CONFIG1				0x15C0
#define USB3_PCS_ALIGN_DETECT_CONFIG2				0x15C4
#define USB3_PCS_ALIGN_DETECT_CONFIG3				0x15C8
#define USB3_PCS_ALIGN_DETECT_CONFIG4				0x15CC
#define USB3_PCS_PCS_TX_RX_CONFIG				0x15D0
#define USB3_PCS_RX_IDLE_DTCT_CNTRL				0x15D4
#define USB3_PCS_RX_DCC_CAL_CONFIG				0x15D8
#define USB3_PCS_EQ_CONFIG1					0x15DC
#define USB3_PCS_EQ_CONFIG2					0x15E0
#define USB3_PCS_EQ_CONFIG3					0x15E4
#define USB3_PCS_EQ_CONFIG4					0x15E8
#define USB3_PCS_EQ_CONFIG5					0x15EC

/* Module: USB3_PCS_USB3_USB3_PCS_USB3_USB3_PCS_USB3 */
#define USB3_PCS_USB3_POWER_STATE_CONFIG1			0x1700
#define USB3_PCS_USB3_AUTONOMOUS_MODE_STATUS			0x1704
#define USB3_PCS_USB3_AUTONOMOUS_MODE_CTRL			0x1708
#define USB3_PCS_USB3_AUTONOMOUS_MODE_CTRL2			0x170C
#define USB3_PCS_USB3_LFPS_RXTERM_IRQ_SOURCE_STATUS		0x1710
#define USB3_PCS_USB3_LFPS_RXTERM_IRQ_CLEAR			0x1714
#define USB3_PCS_USB3_LFPS_DET_HIGH_COUNT_VAL			0x1718
#define USB3_PCS_USB3_LFPS_TX_ECSTART				0x171C
#define USB3_PCS_USB3_LFPS_PER_TIMER_VAL			0x1720
#define USB3_PCS_USB3_LFPS_TX_END_CNT_U3_START			0x1724
#define USB3_PCS_USB3_LFPS_CONFIG1				0x1728
#define USB3_PCS_USB3_RXEQTRAINING_LOCK_TIME			0x172C
#define USB3_PCS_USB3_RXEQTRAINING_WAIT_TIME			0x1730
#define USB3_PCS_USB3_RXEQTRAINING_CTLE_TIME			0x1734
#define USB3_PCS_USB3_RXEQTRAINING_WAIT_TIME_S2			0x1738
#define USB3_PCS_USB3_RXEQTRAINING_DFE_TIME_S2			0x173C
#define USB3_PCS_USB3_RCVR_DTCT_DLY_U3_L			0x1740
#define USB3_PCS_USB3_RCVR_DTCT_DLY_U3_H			0x1744
#define USB3_PCS_USB3_ARCVR_DTCT_EN_PERIOD			0x1748
#define USB3_PCS_USB3_ARCVR_DTCT_CM_DLY				0x174C
#define USB3_PCS_USB3_TXONESZEROS_RUN_LENGTH			0x1750
#define USB3_PCS_USB3_ALFPS_DEGLITCH_VAL			0x1754
#define USB3_PCS_USB3_SIGDET_STARTUP_TIMER_VAL			0x1758
#define USB3_PCS_USB3_TEST_CONTROL				0x175C
#define USB3_PCS_USB3_RXTERMINATION_DLY_SEL			0x1760

/* Module: DP_QSERDES_PLL_DP_QSERDES_PLL_USB4_USB3_DP_QMP_PLL */
#define DP_QSERDES_PLL_ATB_SEL1					0x2000
#define DP_QSERDES_PLL_ATB_SEL2					0x2004
#define DP_QSERDES_PLL_FREQ_UPDATE				0x2008
#define DP_QSERDES_PLL_BG_TIMER					0x200C
#define DP_QSERDES_PLL_SSC_EN_CENTER				0x2010
#define DP_QSERDES_PLL_SSC_ADJ_PER1				0x2014
#define DP_QSERDES_PLL_SSC_ADJ_PER2				0x2018
#define DP_QSERDES_PLL_SSC_PER1					0x201C
#define DP_QSERDES_PLL_SSC_PER2					0x2020
#define DP_QSERDES_PLL_SSC_STEP_SIZE1_MODE0			0x2024
#define DP_QSERDES_PLL_SSC_STEP_SIZE2_MODE0			0x2028
#define DP_QSERDES_PLL_SSC_STEP_SIZE3_MODE0			0x202C
#define DP_QSERDES_PLL_SSC_STEP_SIZE1_MODE1			0x2030
#define DP_QSERDES_PLL_SSC_STEP_SIZE2_MODE1			0x2034
#define DP_QSERDES_PLL_SSC_STEP_SIZE3_MODE1			0x2038
#define DP_QSERDES_PLL_POST_DIV					0x203C
#define DP_QSERDES_PLL_POST_DIV_MUX				0x2040
#define DP_QSERDES_PLL_BIAS_EN_CLKBUFLR_EN			0x2044
#define DP_QSERDES_PLL_CLK_ENABLE1				0x2048
#define DP_QSERDES_PLL_SYS_CLK_CTRL				0x204C
#define DP_QSERDES_PLL_SYSCLK_BUF_ENABLE			0x2050
#define DP_QSERDES_PLL_PLL_EN					0x2054
#define DP_QSERDES_PLL_PLL_IVCO					0x2058
#define DP_QSERDES_PLL_CMN_IETRIM				0x205C
#define DP_QSERDES_PLL_CMN_IPTRIM				0x2060
#define DP_QSERDES_PLL_EP_CLOCK_DETECT_CTRL			0x2064
#define DP_QSERDES_PLL_SYSCLK_DET_COMP_STATUS			0x2068
#define DP_QSERDES_PLL_CLK_EP_DIV_MODE0				0x206C
#define DP_QSERDES_PLL_CLK_EP_DIV_MODE1				0x2070
#define DP_QSERDES_PLL_CP_CTRL_MODE0				0x2074
#define DP_QSERDES_PLL_CP_CTRL_MODE1				0x2078
#define DP_QSERDES_PLL_PLL_RCTRL_MODE0				0x207C
#define DP_QSERDES_PLL_PLL_RCTRL_MODE1				0x2080
#define DP_QSERDES_PLL_PLL_CCTRL_MODE0				0x2084
#define DP_QSERDES_PLL_PLL_CCTRL_MODE1				0x2088
#define DP_QSERDES_PLL_PLL_CNTRL				0x208C
#define DP_QSERDES_PLL_BIAS_EN_CTRL_BY_PSM			0x2090
#define DP_QSERDES_PLL_SYSCLK_EN_SEL				0x2094
#define DP_QSERDES_PLL_CML_SYSCLK_SEL				0x2098
#define DP_QSERDES_PLL_RESETSM_CNTRL				0x209C
#define DP_QSERDES_PLL_RESETSM_CNTRL2				0x20A0
#define DP_QSERDES_PLL_LOCK_CMP_EN				0x20A4
#define DP_QSERDES_PLL_LOCK_CMP_CFG				0x20A8
#define DP_QSERDES_PLL_LOCK_CMP1_MODE0				0x20AC
#define DP_QSERDES_PLL_LOCK_CMP2_MODE0				0x20B0
#define DP_QSERDES_PLL_LOCK_CMP1_MODE1				0x20B4
#define DP_QSERDES_PLL_LOCK_CMP2_MODE1				0x20B8
#define DP_QSERDES_PLL_DEC_START_MODE0				0x20BC
#define DP_QSERDES_PLL_DEC_START_MSB_MODE0			0x20C0
#define DP_QSERDES_PLL_DEC_START_MODE1				0x20C4
#define DP_QSERDES_PLL_DEC_START_MSB_MODE1			0x20C8
#define DP_QSERDES_PLL_DIV_FRAC_START1_MODE0			0x20CC
#define DP_QSERDES_PLL_DIV_FRAC_START2_MODE0			0x20D0
#define DP_QSERDES_PLL_DIV_FRAC_START3_MODE0			0x20D4
#define DP_QSERDES_PLL_DIV_FRAC_START1_MODE1			0x20D8
#define DP_QSERDES_PLL_DIV_FRAC_START2_MODE1			0x20DC
#define DP_QSERDES_PLL_DIV_FRAC_START3_MODE1			0x20E0
#define DP_QSERDES_PLL_INTEGLOOP_INITVAL			0x20E4
#define DP_QSERDES_PLL_INTEGLOOP_EN				0x20E8
#define DP_QSERDES_PLL_INTEGLOOP_GAIN0_MODE0			0x20EC
#define DP_QSERDES_PLL_INTEGLOOP_GAIN1_MODE0			0x20F0
#define DP_QSERDES_PLL_INTEGLOOP_GAIN0_MODE1			0x20F4
#define DP_QSERDES_PLL_INTEGLOOP_GAIN1_MODE1			0x20F8
#define DP_QSERDES_PLL_INTEGLOOP_P_PATH_GAIN0			0x20FC
#define DP_QSERDES_PLL_INTEGLOOP_P_PATH_GAIN1			0x2100
#define DP_QSERDES_PLL_VCOCAL_DEADMAN_CTRL			0x2104
#define DP_QSERDES_PLL_VCO_TUNE_CTRL				0x2108
#define DP_QSERDES_PLL_VCO_TUNE_MAP				0x210C
#define DP_QSERDES_PLL_VCO_TUNE1_MODE0				0x2110
#define DP_QSERDES_PLL_VCO_TUNE2_MODE0				0x2114
#define DP_QSERDES_PLL_VCO_TUNE1_MODE1				0x2118
#define DP_QSERDES_PLL_VCO_TUNE2_MODE1				0x211C
#define DP_QSERDES_PLL_VCO_TUNE_INITVAL1			0x2120
#define DP_QSERDES_PLL_VCO_TUNE_INITVAL2			0x2124
#define DP_QSERDES_PLL_VCO_TUNE_MINVAL1				0x2128
#define DP_QSERDES_PLL_VCO_TUNE_MINVAL2				0x212C
#define DP_QSERDES_PLL_VCO_TUNE_MAXVAL1				0x2130
#define DP_QSERDES_PLL_VCO_TUNE_MAXVAL2				0x2134
#define DP_QSERDES_PLL_VCO_TUNE_TIMER1				0x2138
#define DP_QSERDES_PLL_VCO_TUNE_TIMER2				0x213C
#define DP_QSERDES_PLL_CMN_STATUS				0x2140
#define DP_QSERDES_PLL_RESET_SM_STATUS				0x2144
#define DP_QSERDES_PLL_RESTRIM_CODE_STATUS			0x2148
#define DP_QSERDES_PLL_PLLCAL_CODE1_STATUS			0x214C
#define DP_QSERDES_PLL_PLLCAL_CODE2_STATUS			0x2150
#define DP_QSERDES_PLL_CLK_SELECT				0x2154
#define DP_QSERDES_PLL_HSCLK_SEL				0x2158
#define DP_QSERDES_PLL_HSCLK_HS_SWITCH_SEL			0x215C
#define DP_QSERDES_PLL_INTEGLOOP_BINCODE_STATUS			0x2160
#define DP_QSERDES_PLL_PLL_ANALOG				0x2164
#define DP_QSERDES_PLL_CORECLK_DIV_MODE0			0x2168
#define DP_QSERDES_PLL_CORECLK_DIV_MODE1			0x216C
#define DP_QSERDES_PLL_SW_RESET					0x2170
#define DP_QSERDES_PLL_CORE_CLK_EN				0x2174
#define DP_QSERDES_PLL_C_READY_STATUS				0x2178
#define DP_QSERDES_PLL_CMN_CONFIG				0x217C
#define DP_QSERDES_PLL_CMN_RATE_OVERRIDE			0x2180
#define DP_QSERDES_PLL_SVS_MODE_CLK_SEL				0x2184
#define DP_QSERDES_PLL_DEBUG_BUS0				0x2188
#define DP_QSERDES_PLL_DEBUG_BUS1				0x218C
#define DP_QSERDES_PLL_DEBUG_BUS2				0x2190
#define DP_QSERDES_PLL_DEBUG_BUS3				0x2194
#define DP_QSERDES_PLL_DEBUG_BUS_SEL				0x2198
#define DP_QSERDES_PLL_CMN_MISC1				0x219C
#define DP_QSERDES_PLL_CMN_MODE					0x21A0
#define DP_QSERDES_PLL_CMN_MODE_CONTD				0x21A4
#define DP_QSERDES_PLL_VCO_DC_LEVEL_CTRL			0x21A8
#define DP_QSERDES_PLL_BIN_VCOCAL_CMP_CODE1_MODE0		0x21AC
#define DP_QSERDES_PLL_BIN_VCOCAL_CMP_CODE2_MODE0		0x21B0
#define DP_QSERDES_PLL_BIN_VCOCAL_CMP_CODE1_MODE1		0x21B4
#define DP_QSERDES_PLL_BIN_VCOCAL_CMP_CODE2_MODE1		0x21B8
#define DP_QSERDES_PLL_BIN_VCOCAL_HSCLK_SEL			0x21BC
#define DP_QSERDES_PLL_RESERVED_1				0x21C0
#define DP_QSERDES_PLL_MODE_OPERATION_STATUS			0x21C4

/* Module: DP_DP_DP_PHY */
#define DP_DP_PHY_REVISION_ID0					0x2200
#define DP_DP_PHY_REVISION_ID1					0x2204
#define DP_DP_PHY_REVISION_ID2					0x2208
#define DP_DP_PHY_REVISION_ID3					0x220C
#define DP_DP_PHY_CFG						0x2210
#define DP_DP_PHY_CFG_1						0x2214
#define DP_DP_PHY_PD_CTL					0x2218
#define DP_DP_PHY_MODE						0x221C
#define DP_DP_PHY_AUX_CFG0					0x2220
#define DP_DP_PHY_AUX_CFG1					0x2224
#define DP_DP_PHY_AUX_CFG2					0x2228
#define DP_DP_PHY_AUX_CFG3					0x222C
#define DP_DP_PHY_AUX_CFG4					0x2230
#define DP_DP_PHY_AUX_CFG5					0x2234
#define DP_DP_PHY_AUX_CFG6					0x2238
#define DP_DP_PHY_AUX_CFG7					0x223C
#define DP_DP_PHY_AUX_CFG8					0x2240
#define DP_DP_PHY_AUX_CFG9					0x2244
#define DP_DP_PHY_AUX_CFG10					0x2248
#define DP_DP_PHY_AUX_CFG11					0x224C
#define DP_DP_PHY_AUX_CFG12					0x2250
#define DP_DP_PHY_AUX_INTERRUPT_MASK				0x2254
#define DP_DP_PHY_AUX_INTERRUPT_CLEAR				0x2258
#define DP_DP_PHY_AUX_BIST_CFG					0x225C
#define DP_DP_PHY_AUX_BIST_PRBS_SEED				0x2260
#define DP_DP_PHY_AUX_BIST_PRBS_POLY				0x2264
#define DP_DP_PHY_AUX_TX_PROG_PAT_16B_LSB			0x2268
#define DP_DP_PHY_AUX_TX_PROG_PAT_16B_MSB			0x226C
#define DP_DP_PHY_VCO_DIV					0x2270
#define DP_DP_PHY_TSYNC_OVRD					0x2274
#define DP_DP_PHY_TX0_TX1_LANE_CTL				0x2278
#define DP_DP_PHY_TX0_TX1_BIST_CFG0				0x227C
#define DP_DP_PHY_TX0_TX1_BIST_CFG1				0x2280
#define DP_DP_PHY_TX0_TX1_BIST_CFG2				0x2284
#define DP_DP_PHY_TX0_TX1_BIST_CFG3				0x2288
#define DP_DP_PHY_TX0_TX1_PRBS_SEED_BYTE0			0x228C
#define DP_DP_PHY_TX0_TX1_PRBS_SEED_BYTE1			0x2290
#define DP_DP_PHY_TX0_TX1_BIST_PATTERN0				0x2294
#define DP_DP_PHY_TX0_TX1_BIST_PATTERN1				0x2298
#define DP_DP_PHY_TX2_TX3_LANE_CTL				0x229C
#define DP_DP_PHY_TX2_TX3_BIST_CFG0				0x22A0
#define DP_DP_PHY_TX2_TX3_BIST_CFG1				0x22A4
#define DP_DP_PHY_TX2_TX3_BIST_CFG2				0x22A8
#define DP_DP_PHY_TX2_TX3_BIST_CFG3				0x22AC
#define DP_DP_PHY_TX2_TX3_PRBS_SEED_BYTE0			0x22B0
#define DP_DP_PHY_TX2_TX3_PRBS_SEED_BYTE1			0x22B4
#define DP_DP_PHY_TX2_TX3_BIST_PATTERN0				0x22B8
#define DP_DP_PHY_TX2_TX3_BIST_PATTERN1				0x22BC
#define DP_DP_PHY_MISR_CTRL					0x22C0
#define DP_DP_PHY_DEBUG_BUS_SEL					0x22C4
#define DP_DP_PHY_SPARE0					0x22C8
#define DP_DP_PHY_SPARE1					0x22CC
#define DP_DP_PHY_SPARE2					0x22D0
#define DP_DP_PHY_SPARE3					0x22D4
#define DP_DP_PHY_AUX_INTERRUPT_STATUS				0x22D8
#define DP_DP_PHY_STATUS					0x22DC
#define DP_DP_PHY_AUX_BIST_STATUS0				0x22E0
#define DP_DP_PHY_AUX_BIST_STATUS1				0x22E4
#define DP_DP_PHY_AUX_BIST_STATUS2				0x22E8
#define DP_DP_PHY_TX0_TX1_BIST_STATUS0				0x22EC
#define DP_DP_PHY_TX0_TX1_BIST_STATUS1				0x22F0
#define DP_DP_PHY_TX0_TX1_BIST_STATUS2				0x22F4
#define DP_DP_PHY_TX2_TX3_BIST_STATUS0				0x22F8
#define DP_DP_PHY_TX2_TX3_BIST_STATUS1				0x22FC
#define DP_DP_PHY_TX2_TX3_BIST_STATUS2				0x2300
#define DP_DP_PHY_MISR_STATUS					0x2304
#define DP_DP_PHY_TX0_MISR_STATUS000				0x2308
#define DP_DP_PHY_TX0_MISR_STATUS001				0x230C
#define DP_DP_PHY_TX0_MISR_STATUS010				0x2310
#define DP_DP_PHY_TX0_MISR_STATUS011				0x2314
#define DP_DP_PHY_TX0_MISR_STATUS100				0x2318
#define DP_DP_PHY_TX0_MISR_STATUS101				0x231C
#define DP_DP_PHY_TX0_MISR_STATUS110				0x2320
#define DP_DP_PHY_TX0_MISR_STATUS111				0x2324
#define DP_DP_PHY_TX1_MISR_STATUS000				0x2328
#define DP_DP_PHY_TX1_MISR_STATUS001				0x232C
#define DP_DP_PHY_TX1_MISR_STATUS010				0x2330
#define DP_DP_PHY_TX1_MISR_STATUS011				0x2334
#define DP_DP_PHY_TX1_MISR_STATUS100				0x2338
#define DP_DP_PHY_TX1_MISR_STATUS101				0x233C
#define DP_DP_PHY_TX1_MISR_STATUS110				0x2340
#define DP_DP_PHY_TX1_MISR_STATUS111				0x2344
#define DP_DP_PHY_TX2_MISR_STATUS000				0x2348
#define DP_DP_PHY_TX2_MISR_STATUS001				0x234C
#define DP_DP_PHY_TX2_MISR_STATUS010				0x2350
#define DP_DP_PHY_TX2_MISR_STATUS011				0x2354
#define DP_DP_PHY_TX2_MISR_STATUS100				0x2358
#define DP_DP_PHY_TX2_MISR_STATUS101				0x235C
#define DP_DP_PHY_TX2_MISR_STATUS110				0x2360
#define DP_DP_PHY_TX2_MISR_STATUS111				0x2364
#define DP_DP_PHY_TX3_MISR_STATUS000				0x2368
#define DP_DP_PHY_TX3_MISR_STATUS001				0x236C
#define DP_DP_PHY_TX3_MISR_STATUS010				0x2370
#define DP_DP_PHY_TX3_MISR_STATUS011				0x2374
#define DP_DP_PHY_TX3_MISR_STATUS100				0x2378
#define DP_DP_PHY_TX3_MISR_STATUS101				0x237C
#define DP_DP_PHY_TX3_MISR_STATUS110				0x2380
#define DP_DP_PHY_TX3_MISR_STATUS111				0x2384
#define DP_DP_PHY_DEBUG_BUS0					0x2388
#define DP_DP_PHY_DEBUG_BUS1					0x238C
#define DP_DP_PHY_DEBUG_BUS2					0x2390
#define DP_DP_PHY_DEBUG_BUS3					0x2394

/* Module: USB4_QSERDES_PLL_USB4_QSERDES_PLL_USB4_USB3_DP_QMP_PLL_20G */
#define USB4_QSERDES_PLL_ATB_SEL1				0x3000
#define USB4_QSERDES_PLL_ATB_SEL2				0x3004
#define USB4_QSERDES_PLL_FREQ_UPDATE				0x3008
#define USB4_QSERDES_PLL_BG_TIMER				0x300C
#define USB4_QSERDES_PLL_SSC_EN_CENTER				0x3010
#define USB4_QSERDES_PLL_SSC_ADJ_PER1				0x3014
#define USB4_QSERDES_PLL_SSC_ADJ_PER2				0x3018
#define USB4_QSERDES_PLL_SSC_PER1				0x301C
#define USB4_QSERDES_PLL_SSC_PER2				0x3020
#define USB4_QSERDES_PLL_SSC_STEP_SIZE1_MODE0			0x3024
#define USB4_QSERDES_PLL_SSC_STEP_SIZE2_MODE0			0x3028
#define USB4_QSERDES_PLL_SSC_STEP_SIZE3_MODE0			0x302C
#define USB4_QSERDES_PLL_SSC_STEP_SIZE1_MODE1			0x3030
#define USB4_QSERDES_PLL_SSC_STEP_SIZE2_MODE1			0x3034
#define USB4_QSERDES_PLL_SSC_STEP_SIZE3_MODE1			0x3038
#define USB4_QSERDES_PLL_POST_DIV				0x303C
#define USB4_QSERDES_PLL_POST_DIV_MUX				0x3040
#define USB4_QSERDES_PLL_BIAS_EN_CLKBUFLR_EN			0x3044
#define USB4_QSERDES_PLL_CLK_ENABLE1				0x3048
#define USB4_QSERDES_PLL_SYS_CLK_CTRL				0x304C
#define USB4_QSERDES_PLL_SYSCLK_BUF_ENABLE			0x3050
#define USB4_QSERDES_PLL_PLL_EN					0x3054
#define USB4_QSERDES_PLL_PLL_IVCO				0x3058
#define USB4_QSERDES_PLL_CMN_IETRIM				0x305C
#define USB4_QSERDES_PLL_CMN_IPTRIM				0x3060
#define USB4_QSERDES_PLL_EP_CLOCK_DETECT_CTRL			0x3064
#define USB4_QSERDES_PLL_SYSCLK_DET_COMP_STATUS			0x3068
#define USB4_QSERDES_PLL_CLK_EP_DIV_MODE0			0x306C
#define USB4_QSERDES_PLL_CLK_EP_DIV_MODE1			0x3070
#define USB4_QSERDES_PLL_CP_CTRL_MODE0				0x3074
#define USB4_QSERDES_PLL_CP_CTRL_MODE1				0x3078
#define USB4_QSERDES_PLL_PLL_RCTRL_MODE0			0x307C
#define USB4_QSERDES_PLL_PLL_RCTRL_MODE1			0x3080
#define USB4_QSERDES_PLL_PLL_CCTRL_MODE0			0x3084
#define USB4_QSERDES_PLL_PLL_CCTRL_MODE1			0x3088
#define USB4_QSERDES_PLL_PLL_CNTRL				0x308C
#define USB4_QSERDES_PLL_BIAS_EN_CTRL_BY_PSM			0x3090
#define USB4_QSERDES_PLL_SYSCLK_EN_SEL				0x3094
#define USB4_QSERDES_PLL_CML_SYSCLK_SEL				0x3098
#define USB4_QSERDES_PLL_RESETSM_CNTRL				0x309C
#define USB4_QSERDES_PLL_RESETSM_CNTRL2				0x30A0
#define USB4_QSERDES_PLL_LOCK_CMP_EN				0x30A4
#define USB4_QSERDES_PLL_LOCK_CMP_CFG				0x30A8
#define USB4_QSERDES_PLL_LOCK_CMP1_MODE0			0x30AC
#define USB4_QSERDES_PLL_LOCK_CMP2_MODE0			0x30B0
#define USB4_QSERDES_PLL_LOCK_CMP1_MODE1			0x30B4
#define USB4_QSERDES_PLL_LOCK_CMP2_MODE1			0x30B8
#define USB4_QSERDES_PLL_DEC_START_MODE0			0x30BC
#define USB4_QSERDES_PLL_DEC_START_MSB_MODE0			0x30C0
#define USB4_QSERDES_PLL_DEC_START_MODE1			0x30C4
#define USB4_QSERDES_PLL_DEC_START_MSB_MODE1			0x30C8
#define USB4_QSERDES_PLL_DIV_FRAC_START1_MODE0			0x30CC
#define USB4_QSERDES_PLL_DIV_FRAC_START2_MODE0			0x30D0
#define USB4_QSERDES_PLL_DIV_FRAC_START3_MODE0			0x30D4
#define USB4_QSERDES_PLL_DIV_FRAC_START1_MODE1			0x30D8
#define USB4_QSERDES_PLL_DIV_FRAC_START2_MODE1			0x30DC
#define USB4_QSERDES_PLL_DIV_FRAC_START3_MODE1			0x30E0
#define USB4_QSERDES_PLL_INTEGLOOP_INITVAL			0x30E4
#define USB4_QSERDES_PLL_INTEGLOOP_EN				0x30E8
#define USB4_QSERDES_PLL_INTEGLOOP_GAIN0_MODE0			0x30EC
#define USB4_QSERDES_PLL_INTEGLOOP_GAIN1_MODE0			0x30F0
#define USB4_QSERDES_PLL_INTEGLOOP_GAIN0_MODE1			0x30F4
#define USB4_QSERDES_PLL_INTEGLOOP_GAIN1_MODE1			0x30F8
#define USB4_QSERDES_PLL_INTEGLOOP_P_PATH_GAIN0			0x30FC
#define USB4_QSERDES_PLL_INTEGLOOP_P_PATH_GAIN1			0x3100
#define USB4_QSERDES_PLL_VCOCAL_DEADMAN_CTRL			0x3104
#define USB4_QSERDES_PLL_VCO_TUNE_CTRL				0x3108
#define USB4_QSERDES_PLL_VCO_TUNE_MAP				0x310C
#define USB4_QSERDES_PLL_VCO_TUNE1_MODE0			0x3110
#define USB4_QSERDES_PLL_VCO_TUNE2_MODE0			0x3114
#define USB4_QSERDES_PLL_VCO_TUNE1_MODE1			0x3118
#define USB4_QSERDES_PLL_VCO_TUNE2_MODE1			0x311C
#define USB4_QSERDES_PLL_VCO_TUNE_INITVAL1			0x3120
#define USB4_QSERDES_PLL_VCO_TUNE_INITVAL2			0x3124
#define USB4_QSERDES_PLL_VCO_TUNE_MINVAL1			0x3128
#define USB4_QSERDES_PLL_VCO_TUNE_MINVAL2			0x312C
#define USB4_QSERDES_PLL_VCO_TUNE_MAXVAL1			0x3130
#define USB4_QSERDES_PLL_VCO_TUNE_MAXVAL2			0x3134
#define USB4_QSERDES_PLL_VCO_TUNE_TIMER1			0x3138
#define USB4_QSERDES_PLL_VCO_TUNE_TIMER2			0x313C
#define USB4_QSERDES_PLL_CMN_STATUS				0x3140
#define USB4_QSERDES_PLL_RESET_SM_STATUS			0x3144
#define USB4_QSERDES_PLL_RESTRIM_CODE_STATUS			0x3148
#define USB4_QSERDES_PLL_PLLCAL_CODE1_STATUS			0x314C
#define USB4_QSERDES_PLL_PLLCAL_CODE2_STATUS			0x3150
#define USB4_QSERDES_PLL_CLK_SELECT				0x3154
#define USB4_QSERDES_PLL_HSCLK_SEL				0x3158
#define USB4_QSERDES_PLL_HSCLK_HS_SWITCH_SEL			0x315C
#define USB4_QSERDES_PLL_INTEGLOOP_BINCODE_STATUS		0x3160
#define USB4_QSERDES_PLL_PLL_ANALOG				0x3164
#define USB4_QSERDES_PLL_CORECLK_DIV_MODE0			0x3168
#define USB4_QSERDES_PLL_CORECLK_DIV_MODE1			0x316C
#define USB4_QSERDES_PLL_SW_RESET				0x3170
#define USB4_QSERDES_PLL_CORE_CLK_EN				0x3174
#define USB4_QSERDES_PLL_C_READY_STATUS				0x3178
#define USB4_QSERDES_PLL_CMN_CONFIG				0x317C
#define USB4_QSERDES_PLL_CMN_RATE_OVERRIDE			0x3180
#define USB4_QSERDES_PLL_SVS_MODE_CLK_SEL			0x3184
#define USB4_QSERDES_PLL_DEBUG_BUS0				0x3188
#define USB4_QSERDES_PLL_DEBUG_BUS1				0x318C
#define USB4_QSERDES_PLL_DEBUG_BUS2				0x3190
#define USB4_QSERDES_PLL_DEBUG_BUS3				0x3194
#define USB4_QSERDES_PLL_DEBUG_BUS_SEL				0x3198
#define USB4_QSERDES_PLL_CMN_MISC1				0x319C
#define USB4_QSERDES_PLL_CMN_MODE				0x31A0
#define USB4_QSERDES_PLL_CMN_MODE_CONTD				0x31A4
#define USB4_QSERDES_PLL_VCO_DC_LEVEL_CTRL			0x31A8
#define USB4_QSERDES_PLL_BIN_VCOCAL_CMP_CODE1_MODE0		0x31AC
#define USB4_QSERDES_PLL_BIN_VCOCAL_CMP_CODE2_MODE0		0x31B0
#define USB4_QSERDES_PLL_BIN_VCOCAL_CMP_CODE1_MODE1		0x31B4
#define USB4_QSERDES_PLL_BIN_VCOCAL_CMP_CODE2_MODE1		0x31B8
#define USB4_QSERDES_PLL_BIN_VCOCAL_HSCLK_SEL			0x31BC
#define USB4_QSERDES_PLL_ADDITIONAL_CTRL_1			0x31C0
#define USB4_QSERDES_PLL_MODE_OPERATION_STATUS			0x31C4
#define USB4_QSERDES_PLL_AUTO_GAIN_ADJ_CTRL_1			0x31C8
#define USB4_QSERDES_PLL_AUTO_GAIN_ADJ_CTRL_2			0x31CC
#define USB4_QSERDES_PLL_AUTO_GAIN_ADJ_CTRL_3			0x31D0
#define USB4_QSERDES_PLL_AUTO_GAIN_ADJ_CTRL_4			0x31D4
#define USB4_QSERDES_PLL_ADDITIONAL_MISC			0x31D8
#define USB4_QSERDES_PLL_ADDITIONAL_MISC_2			0x31DC
#define USB4_QSERDES_PLL_ADDITIONAL_MISC_3			0x31E0

/* Module: USB4_PCS_L0_USB4_PCS_L0_USB4_PCS_LANE */
#define USB4_PCS_L0_PCS_STATUS1					0x3200
#define USB4_PCS_L0_PCS_STATUS2					0x3204
#define USB4_PCS_L0_PCS_STATUS3					0x3208
#define USB4_PCS_L0_BIST_CHK_ERR_CNT_L_STATUS			0x320C
#define USB4_PCS_L0_BIST_CHK_ERR_CNT_H_STATUS			0x3210
#define USB4_PCS_L0_BIST_CHK_STATUS				0x3214
#define USB4_PCS_L0_INSIG_SW_CTRL1				0x3218
#define USB4_PCS_L0_INSIG_SW_CTRL2				0x321C
#define USB4_PCS_L0_INSIG_MX_CTRL1				0x3220
#define USB4_PCS_L0_INSIG_MX_CTRL2				0x3224
#define USB4_PCS_L0_OUTSIG_SW_CTRL1				0x3228
#define USB4_PCS_L0_OUTSIG_SW_CTRL2				0x322C
#define USB4_PCS_L0_OUTSIG_MX_CTRL1				0x3230
#define USB4_PCS_L0_OUTSIG_MX_CTRL2				0x3234
#define USB4_PCS_L0_PRESET_OVERRIDE_CONFIG			0x3238
#define USB4_PCS_L0_TEST_CONTROL1				0x323C
#define USB4_PCS_L0_TEST_CONTROL2				0x3240
#define USB4_PCS_L0_TEST_CONTROL3				0x3244
#define USB4_PCS_L0_BIST_CTRL					0x3248
#define USB4_PCS_L0_PRBS_SEED0					0x324C
#define USB4_PCS_L0_PRBS_SEED1					0x3250
#define USB4_PCS_L0_LANE_OFF_CONFIG				0x3254
#define USB4_PCS_L0_RXEQ_STATUS1				0x3258
#define USB4_PCS_L0_RXEQ_STATUS2				0x325C
#define USB4_PCS_L0_RX_MARGINING_CTRL1				0x3260
#define USB4_PCS_L0_RX_MARGINING_STATUS1			0x3264
#define USB4_PCS_L0_RX_MARGINING_STATUS2			0x3268

/* Module: USB4_PCS_L1_USB4_PCS_L1_USB4_PCS_LANE */
#define USB4_PCS_L1_PCS_STATUS1					0x3300
#define USB4_PCS_L1_PCS_STATUS2					0x3304
#define USB4_PCS_L1_PCS_STATUS3					0x3308
#define USB4_PCS_L1_BIST_CHK_ERR_CNT_L_STATUS			0x330C
#define USB4_PCS_L1_BIST_CHK_ERR_CNT_H_STATUS			0x3310
#define USB4_PCS_L1_BIST_CHK_STATUS				0x3314
#define USB4_PCS_L1_INSIG_SW_CTRL1				0x3318
#define USB4_PCS_L1_INSIG_SW_CTRL2				0x331C
#define USB4_PCS_L1_INSIG_MX_CTRL1				0x3320
#define USB4_PCS_L1_INSIG_MX_CTRL2				0x3324
#define USB4_PCS_L1_OUTSIG_SW_CTRL1				0x3328
#define USB4_PCS_L1_OUTSIG_SW_CTRL2				0x332C
#define USB4_PCS_L1_OUTSIG_MX_CTRL1				0x3330
#define USB4_PCS_L1_OUTSIG_MX_CTRL2				0x3334
#define USB4_PCS_L1_PRESET_OVERRIDE_CONFIG			0x3338
#define USB4_PCS_L1_TEST_CONTROL1				0x333C
#define USB4_PCS_L1_TEST_CONTROL2				0x3340
#define USB4_PCS_L1_TEST_CONTROL3				0x3344
#define USB4_PCS_L1_BIST_CTRL					0x3348
#define USB4_PCS_L1_PRBS_SEED0					0x334C
#define USB4_PCS_L1_PRBS_SEED1					0x3350
#define USB4_PCS_L1_LANE_OFF_CONFIG				0x3354
#define USB4_PCS_L1_RXEQ_STATUS1				0x3358
#define USB4_PCS_L1_RXEQ_STATUS2				0x335C
#define USB4_PCS_L1_RX_MARGINING_CTRL1				0x3360
#define USB4_PCS_L1_RX_MARGINING_STATUS1			0x3364
#define USB4_PCS_L1_RX_MARGINING_STATUS2			0x3368

/* Module: USB4_PCS_USB4_PCS_USB4_PCS */
#define USB4_PCS_SW_RESET					0x3400
#define USB4_PCS_REVISION_ID0					0x3404
#define USB4_PCS_REVISION_ID1					0x3408
#define USB4_PCS_REVISION_ID2					0x340C
#define USB4_PCS_REVISION_ID3					0x3410
#define USB4_PCS_PCS_STATUS1					0x3414
#define USB4_PCS_PCS_STATUS2					0x3418
#define USB4_PCS_PCS_STATUS3					0x341C
#define USB4_PCS_PCS_STATUS4					0x3420
#define USB4_PCS_PCS_STATUS5					0x3424
#define USB4_PCS_PCS_STATUS6					0x3428
#define USB4_PCS_PCS_STATUS7					0x342C
#define USB4_PCS_DEBUG_BUS_0_STATUS				0x3430
#define USB4_PCS_DEBUG_BUS_1_STATUS				0x3434
#define USB4_PCS_DEBUG_BUS_2_STATUS				0x3438
#define USB4_PCS_DEBUG_BUS_3_STATUS				0x343C
#define USB4_PCS_POWER_DOWN_CONTROL				0x3440
#define USB4_PCS_START_CONTROL					0x3444
#define USB4_PCS_INSIG_SW_CTRL1					0x3448
#define USB4_PCS_INSIG_SW_CTRL2					0x344C
#define USB4_PCS_INSIG_SW_CTRL3					0x3450
#define USB4_PCS_INSIG_SW_CTRL4					0x3454
#define USB4_PCS_INSIG_SW_CTRL5					0x3458
#define USB4_PCS_INSIG_SW_CTRL6					0x345C
#define USB4_PCS_INSIG_SW_CTRL7					0x3460
#define USB4_PCS_INSIG_SW_CTRL8					0x3464
#define USB4_PCS_INSIG_MX_CTRL1					0x3468
#define USB4_PCS_INSIG_MX_CTRL2					0x346C
#define USB4_PCS_INSIG_MX_CTRL3					0x3470
#define USB4_PCS_INSIG_MX_CTRL4					0x3474
#define USB4_PCS_INSIG_MX_CTRL5					0x3478
#define USB4_PCS_INSIG_MX_CTRL8					0x347C
#define USB4_PCS_OUTSIG_SW_CTRL1				0x3480
#define USB4_PCS_OUTSIG_MX_CTRL1				0x3484
#define USB4_PCS_OUTSIG_SW_CTRL2				0x3488
#define USB4_PCS_OUTSIG_MX_CTRL2				0x348C
#define USB4_PCS_POWER_STATE_CONFIG1				0x3490
#define USB4_PCS_POWER_STATE_CONFIG2				0x3494
#define USB4_PCS_POWER_STATE_CONFIG3				0x3498
#define USB4_PCS_POWER_STATE_CONFIG4				0x349C
#define USB4_PCS_FLL_CNTRL1					0x34A0
#define USB4_PCS_FLL_CNTRL2					0x34A4
#define USB4_PCS_FLL_CNT_VAL_L					0x34A8
#define USB4_PCS_FLL_CNT_VAL_H_TOL				0x34AC
#define USB4_PCS_FLL_MAN_CODE					0x34B0
#define USB4_PCS_TEST_CONTROL1					0x34B4
#define USB4_PCS_TEST_CONTROL2					0x34B8
#define USB4_PCS_TEST_CONTROL3					0x34BC
#define USB4_PCS_TEST_CONTROL4					0x34C0
#define USB4_PCS_TEST_CONTROL5					0x34C4
#define USB4_PCS_TEST_CONTROL6					0x34C8
#define USB4_PCS_TEST_CONTROL7					0x34CC
#define USB4_PCS_LOCK_DETECT_CONFIG1				0x34D0
#define USB4_PCS_LOCK_DETECT_CONFIG2				0x34D4
#define USB4_PCS_REFGEN_REQ_CONFIG1				0x34D8
#define USB4_PCS_REFGEN_REQ_CONFIG2				0x34DC
#define USB4_PCS_REFGEN_REQ_CONFIG3				0x34E0
#define USB4_PCS_BIST_CTRL					0x34E4
#define USB4_PCS_BIST_CONFIG1					0x34E8
#define USB4_PCS_BIST_CONFIG2					0x34EC
#define USB4_PCS_BIST_CONFIG3					0x34F0
#define USB4_PCS_TXMGN_CONFIG					0x34F4
#define USB4_PCS_G3_TXMGN_MAIN					0x34F8
#define USB4_PCS_G3_TXMGN_MAIN_RS				0x34FC
#define USB4_PCS_G3_PRE_GAIN					0x3500
#define USB4_PCS_G3_POST_GAIN					0x3504
#define USB4_PCS_G3_PRE_POST_OFFSET				0x3508
#define USB4_PCS_G3_PRE_GAIN_RS					0x350C
#define USB4_PCS_G3_POST_GAIN_RS				0x3510
#define USB4_PCS_G3_PRE_POST_OFFSET_RS				0x3514
#define USB4_PCS_G2_TXMGN_MAIN					0x3518
#define USB4_PCS_G2_TXMGN_MAIN_RS				0x351C
#define USB4_PCS_G2_PRE_GAIN					0x3520
#define USB4_PCS_G2_POST_GAIN					0x3524
#define USB4_PCS_G2_PRE_POST_OFFSET				0x3528
#define USB4_PCS_G2_PRE_GAIN_RS					0x352C
#define USB4_PCS_G2_POST_GAIN_RS				0x3530
#define USB4_PCS_G2_PRE_POST_OFFSET_RS				0x3534
#define USB4_PCS_TXCOEFF_CONFIG					0x3538
#define USB4_PCS_PRESET_P0_P1_PRE				0x353C
#define USB4_PCS_PRESET_P2_P3_PRE				0x3540
#define USB4_PCS_PRESET_P4_P5_PRE				0x3544
#define USB4_PCS_PRESET_P6_P7_PRE				0x3548
#define USB4_PCS_PRESET_P8_P9_PRE				0x354C
#define USB4_PCS_PRESET_P10_P11_PRE				0x3550
#define USB4_PCS_PRESET_P12_P13_PRE				0x3554
#define USB4_PCS_PRESET_P14_P15_PRE				0x3558
#define USB4_PCS_PRESET_P0_P1_POST				0x355C
#define USB4_PCS_PRESET_P2_P3_POST				0x3560
#define USB4_PCS_PRESET_P4_P5_POST				0x3564
#define USB4_PCS_PRESET_P6_P7_POST				0x3568
#define USB4_PCS_PRESET_P8_P9_POST				0x356C
#define USB4_PCS_PRESET_P10_P11_POST				0x3570
#define USB4_PCS_PRESET_P12_P13_POST				0x3574
#define USB4_PCS_PRESET_P14_P15_POST				0x3578
#define USB4_PCS_RX_SIGDET_LVL					0x357C
#define USB4_PCS_RX_SIGDET_DTCT_CNTRL				0x3580
#define USB4_PCS_RATE_SLEW_CNTRL				0x3584
#define USB4_PCS_PWRUP_RESET_DLY_TIME_AUXCLK			0x3588
#define USB4_PCS_C3_WAKEUP_DLY_TIME_AUXCLK_L			0x358C
#define USB4_PCS_C3_WAKEUP_DLY_TIME_AUXCLK_H			0x3590
#define USB4_PCS_TSYNC_RSYNC_TIME				0x3594
#define USB4_PCS_CDR_RESET_TIME					0x3598
#define USB4_PCS_TSYNC_DLY_TIME					0x359C
#define USB4_PCS_ELECIDLE_DLY_SEL				0x35A0
#define USB4_PCS_CMN_ACK_OUT_SEL				0x35A4
#define USB4_PCS_PCS_TX_RX_CONFIG1				0x35A8
#define USB4_PCS_PCS_TX_RX_CONFIG2				0x35AC
#define USB4_PCS_PCS_TX_RX_CONFIG3				0x35B0
#define USB4_PCS_RX_DCC_CAL_CONFIG				0x35B4
#define USB4_PCS_EQ_CONFIG1					0x35B8
#define USB4_PCS_EQ_CONFIG2					0x35BC
#define USB4_PCS_G2_EQ_CONFIG1					0x35C0
#define USB4_PCS_G2_EQ_CONFIG2					0x35C4
#define USB4_PCS_G2_EQ_CONFIG3					0x35C8
#define USB4_PCS_G2_EQ_CONFIG4					0x35CC
#define USB4_PCS_G2_EQ_CONFIG5					0x35D0
#define USB4_PCS_G2_EQ_CONFIG6					0x35D4
#define USB4_PCS_G3_EQ_CONFIG1					0x35D8
#define USB4_PCS_G3_EQ_CONFIG2					0x35DC
#define USB4_PCS_G3_EQ_CONFIG3					0x35E0
#define USB4_PCS_G3_EQ_CONFIG4					0x35E4
#define USB4_PCS_G3_EQ_CONFIG5					0x35E8
#define USB4_PCS_G3_EQ_CONFIG6					0x35EC
#define USB4_PCS_FOM_EQ_CONFIG1					0x35F0
#define USB4_PCS_FOM_EQ_CONFIG2					0x35F4
#define USB4_PCS_FOM_EQ_CONFIG3					0x35F8
#define USB4_PCS_FOM_EQ_CONFIG4					0x35FC
#define USB4_PCS_LFPS_DET_HIGH_COUNT_VAL			0x3600
#define USB4_PCS_LFPS_TX_ECSTART				0x3604
#define USB4_PCS_LFPS_TX_END_CNT_C3_START			0x3608
#define USB4_PCS_MBUS_CONFIG1					0x360C
#define USB4_PCS_MBUS_CTRL1					0x3610
#define USB4_PCS_MBUS_CTRL2					0x3614
#define USB4_PCS_MBUS_CTRL3					0x3618
#define USB4_PCS_MBUS_CTRL4					0x361C
#define USB4_PCS_MBUS_STATUS1					0x3620
#define USB4_PCS_RX_MARGINING_CONFIG1				0x3624
#define USB4_PCS_RX_MARGINING_CONFIG2				0x3628
#define USB4_PCS_RX_MARGINING_CONFIG3				0x362C
#define USB4_PCS_WAKEUP_CLK_CONFIG1				0x3630
#define USB4_PCS_WAKEUP_CLK_CONFIG2				0x3634
#define USB4_PCS_WAKEUP_CLK_STATUS				0x3638
#define USB4_PCS_TX_LATENCY_MEAS_CONFIG1			0x363C
#define USB4_PCS_TX_LATENCY_MEAS_CONFIG2			0x3640
#define USB4_PCS_TX_LATENCY_STATUS				0x3644
#define USB4_PCS_SIGDET_CNTRL					0x3648

#endif /* _DT_BINDINGS_PHY_QCOM_5NM_QMP_COMBO_USB4_H */
